import constraint

problem = constraint.Problem()
# Dodajemo promenljivu P za psenicu i definisemo njen domen
# min{320, 20000/50, 23000/70} = 320 
problem.addVariable('P', range(0,321))

# Dodajemo promenljivu S za soju i definisemo njen domen
# min{320, 20000/60, 23000/80} =  287.5
problem.addVariable('S', range(0,288))

# ogranicenje za ukupan broj hektara koje treba zasaditi
def ukupno(p,s):
	if p+s==320:
		return True

# ogranicenje za kapacitet skladista
def kapacitet(p,s):
	if p*70+s*80<=23000:
		return True
# ogranicenje za raspoloziv novac
def novac(p,s):
    if p*50+s*60 <= 20000:
        return True


problem.addConstraint(ukupno, 'PS')
problem.addConstraint(kapacitet, 'PS')
problem.addConstraint(novac, 'PS')
resenja = problem.getSolutions()

# Pronalazimo maksimalnu vrednost funkcije cilja
maxPsenica = 0
maxSoja = 0
maxZarada = 0
# od ostvarene dobiti oduzimamo koliko je novca potrozeno na sadnju
for r in resenja:
    if 70*10*r['P'] + 80*12*r['S'] - (50*r['P'] + 60*r['S']) > maxZarada :
        maxPsenica = r['P']
        maxSoja = r['S']
	maxZarada = 70*10*r['P'] + 80*12*r['S'] - (50*r['P'] + 60*r['S'])


print "{:d} {:d} {:d}".format(maxZarada, maxPsenica, maxSoja)



