// prevodjenje programa: g++ 5.cpp Trougao.cpp Polinom.cpp

#include <iostream>
#include "Trougao.h"
#include "Polinom.h"

/* povratna vrednost je objekat tipa T, ako bi vracali referencu, kompajler prijavljuje upozorenje
 * jer bi to bila referenca na lokalnu promenljivu zbir sto nam svakako ne odgovara */
template <typename T>
T n_tostruki(const T& x, int n){
	int i=1;
	T zbir = x;
	while(i<n){
		zbir = zbir + x;
		i++;
	}		
  return zbir;
}

template <typename T>
const T& manji(const T& x, const T& y){
	if(x<y)
		return x;		
	else
		return y;
}

template <typename T>
T zbir(const T& x, const T& y){
	return x+y;
}

int main(){
	double koef[5] = { 1, 2, 3, 4, 5 };
	algebra::Polinom p(4, koef);
	double koef2[7] = { 10, 20, 15, 4, 6 };
	algebra::Polinom q(6, koef2);	
	geometrija::Trougao t(2, 3, 4);
	geometrija::Trougao s(5, 6, 7);
	float x = 10.3, y = 101.1;
	int a = 5, b = 10, n = 3;
	 
	std::cout<< "Manji od trouglova " << t << " i " << s << " je: " << manji<geometrija::Trougao>(t,s)<< std::endl; 
	std::cout<< "Manji od brojeva " << x << " i " << y << " je: " << manji<float>(x,y)<< std::endl;
	std::cout<< "Manji od brojeva " << a << " i " << b << " je: " << manji<int>(a,b)<< std::endl;

	std::cout<< "Zbir trouglova " << t << " i " << s << " je: " << zbir<geometrija::Trougao>(t,s)<< std::endl;   	
	std::cout<< "Zbir polinoma " << p << " i " << q << " je: " << zbir<algebra::Polinom>(p,q)<< std::endl;
	
	std::cout<< n << " * " << a << " = " << n_tostruki<int>(a,n)<<std::endl;
	std::cout<< n << " * " << x << " = " << n_tostruki<float>(x,n)<<std::endl;
	std::cout<< n << " * (" << q << ") = " << n_tostruki<algebra::Polinom>(q,n)<<std::endl;  

}
