#include "Osoba.h"

namespace vrsta{ 

Osoba::Osoba(void){
	_ime="";
	_prezime="";
	_godinaRodjenja=0;
}

Osoba::Osoba(const std::string& ime, const std::string& prezime, int god){
	_ime=ime;
	_prezime=prezime;
	_godinaRodjenja=god;
}

Osoba::~Osoba(){
	//nema dinamickog sadrzaja
}

const std::string& Osoba::Ime() const{
	return _ime;
}

const std::string& Osoba::Prezime() const{
	return _prezime;
}

int Osoba::GodinaRodjenja() const{
	return _godinaRodjenja;
}

void Osoba::postaviIme(const std::string& ime){
	_ime = ime;
}

void Osoba::postaviPrezime(const std::string& prezime){
	_prezime = prezime;
}

void Osoba::postaviGodinaRodjenja(int godina){
	_godinaRodjenja = godina;
}

bool Osoba::operator<(const Osoba &o1) const{
	return _godinaRodjenja<o1.GodinaRodjenja();
}

std::ostream& operator<<(std::ostream& out, const Osoba &osoba){
	out<<osoba.Ime()<<" "<<osoba.Prezime()<<" "<<osoba.GodinaRodjenja();
	return out;
}

std::istream& operator>>(std::istream& in, Osoba &osoba){
	std::string ime, prezime;
	int god;
	in>>ime>>prezime>>god;
	osoba.postaviIme(ime);
	osoba.postaviPrezime(prezime);
	osoba.postaviGodinaRodjenja(god);
	return in;
}

}
