#ifndef POLINOM_H
#define POLINOM_H
#include <iostream>

namespace algebra{
/* Klasa predstavlja polinom sa realnim koeficientima */
class Polinom {

public:
	/* Konstruktor kreira polinom stepena n sa zadatim nizom koeficienata */
	Polinom(int n, const double * koef);
	/* Konstruktor kreira polinom stepena n, ali ne inicijalizuje njegove 
	 koeficiente. Ovaj konstru*ktor se koristi interno u metodama same klase
	 i nema ga mnogo smisla koristiti van klase, u programu. Zbog toga njega
	 oznacavamo kao privatni. Time sprecavamo koriscenje ovog konstruktora
	 van metoda same klase. */
private:
	Polinom(int n);
	void init(int n, const double *koef=NULL);
	void deinit();
public:
	/* Konstruktor kopiranja je konstruktor koji omogucava da se objekat 
	 i nicijalizuje pomocu drugog objekta iste klas*e. Ovaj konstruktor uvek
	 postoji, a poziva se svaki put kada definisemo objekat klase koji 
	 inicijalizujemo drugim objektom iste klase. Ukoliko programer ne 
	 definise eksplicitno konstruktor kopiranja, tada se poziva implicitni
	 konstruktor kopiranja cija je semantika ekvivalentna onoj koja je
	 nasledjena od C-ovih struktura: prosto se kopira clan po clan klase
	 (za clanove klasnih tipova, poziva se njihov konstruktor kopiranja, 
	 koji opet moze za njihove klase implicitno ili eksplicitno definisan). 
	 Kopiraju se samo nestaticki podaci clanovi. 
	 
	 Cesto nam ta podrazumevana semantika ne odgovara. U nasem slucaju, ovo
	 bi dovelo do tzv. "plitkog" kopiranja objekta klase Polinom: kopirao bi
	 se samo pokazivac (koji je clan klase), a ne i niz na koji on pokazuje
	 (koji nije clan klase, vec je pridruzen objektu klase u konstruktoru). 
	 Samim tim, novokreirani Polinom bi pokazivao na isti niz pokazivaca kao
	 i onaj Polinom kojim je inicijalizovan. Zbog toga mi moramo promeniti
	 ovu semantiku tako sto definisemo eksplicitno konstruktor kopiranja.
	 U pitanju je konstruktor koji kao parametar ima objekat klase polinom,
	 ili (sto je tipicno) referencu na njega. Konstruktor sa ovakvom 
	 deklaracijom automatski redefinise ugradjeni konstruktor kopiranja. 
	 U nasem slucaju, mi kreiramo novi niz koeficienata, a onda kopiramo 
	 stari niz u novi niz ("duboko" kopiranje). */
	Polinom(const Polinom & p);
	int vratiStepen() const;
	double & operator [](int k);
	const double & operator [](int k) const;
	Polinom & operator = (const Polinom & p);
	Polinom operator + (const Polinom & p) const;
	double operator () (double x) const;
	~Polinom();

private:
	int _n; // stepen polinoma
	double * _koef; // pokazivac na niz koeficienata (duzine _n + 1)
	
	/* Clanovi klase mogu biti deklarisani kao staticki (tako sto
	 se kljucna rec static stavi ispred deklaracije clana klase). U slucaju
	 podataka clanova klase, to znaci da je ovaj podatak zajednicki za sve
	 instance klase. Drugim recima, za razliku od nestatickih podataka clanova
	 koji su deo samog objekta klase (samim tim, svaki objekat ima svoje kopije
	 tih clanova), staticki clanovi nisu deo objekta (samim tim, ne uticu ni
	 na njegovu velicinu), vec postoji jedinstveni podatak (negde u memoriji)
	 koji je zajednicki za sve objekte te klase. Prva posledica je da se
	 statickim clanovima ne pristupa preko pokazivaca this (ni implicitno, ni
	 eksplicitno). Druga posledica je da promene ovog clana od strane jednog
	 objekta automatski bivaju vidljive i iz drugog objekta. 
	 
	 Za staticke clanove klase vaze ista pravila pristupa kao i za nestaticke.
	 Ono sto je zgodno kod statickih clanova je da se oni, ukoliko su javni,
	 mogu koristiti cak i ako nemate ni jedan kreirani objekat klase (jer oni
	 i nisu vezani ni za jedan konkretan objekat). Sintaksa je sledeca:
	 
	 ImeKlase::ime_clana_klase
	 
	 umesto
	 
	 a.ime_clana_klase
	 
	 gde je a objekat date klase. Naravno, i ova druga sintaksa je dozvoljena,
	 ali nema mnogo smisla, jer koriscenje statickog clana ni na koji nacin
	 nece biti vezano za objekat a. 
	 
	 Staticki clanovi se nikada ne inicijalizuju u listi inicijalizacija u 
	 konstruktoru, jer staticki clanovi nisu deo objekta koji se kreira. */
  
	static double _nula; // staticki clan

};

/* Operator ispisa polinoma */
std::ostream& operator << (std::ostream& ostr, const Polinom& p);

}
#endif
