#ifndef LISTA_H
#define LISTA_H
#include<iostream>

/* dodajemo u vec napravljen prostor imena kolekcija novu sablonsku klasu koja predstavlja drugi tip kolekcije podataka, tj. listu */
namespace kolekcija{
/* Klasa koja predstavlja element liste*/
template <class T>
class ElementListe{
	public:
		/* Vrednosti podataka objekata ove klase se uvek inicijalizuju, jer elemente liste pravimo za konkretne podatke, tako da nam nije potreban podrazumevani konstruktor */		
		ElementListe( const T& v, ElementListe* s ) : _vrednost(v), _sledeci(s){ 
		
		}
		const T& vratiVrednost() const{
			return _vrednost;
		}
		void postaviVrednost(const T& v){
			_vrednost = v;
		}
		ElementListe* vratiSledeci() const{
			return _sledeci;
		}
		void postaviSledeci(ElementListe* sledeci){
			_sledeci = sledeci;
		}
	
	private:
		T _vrednost; 
		ElementListe* _sledeci;
};

template <class T>
class Lista{
	public:
		/* Podrazumevani konstruktori prostih tipova, pa i pokazivaca, ne izvode nikakvu inicijalizaciju sto nama ne odgovara, jer je za praznu listu potrebno da pokazivac na pocetak bude prazan, pa je potrebno napisati odgovarajuci konstruktor bez argumenata */
		Lista() :_pocetak(NULL), _velicina(0){
			
		}
		
		/* Konstruktor vrsi duboko kopiranje liste ( podrazumevano ponasanje nam ne odgovara jer bi u tom slucaju elementi liste bili deljeni ), za ElementListe nije potrebno definisati konstruktor kopije jer objekte ove klase posmatramo u okviru objekta klase Lista koja vodi racuna o pravilnom kopiranju za svoje elemente */ 
		Lista( const Lista& l ){
			init(l);
		}

		// Destruktor je neophodan jer imamo dinamicki podatak kao clan liste
		~Lista(){
			deinit();
		}

		const ElementListe<T>* vratiPocetak() const{
			return _pocetak;
		}
		// Funkcija vraca i-ti element liste ili NULL ukoliko on ne postoji
		const ElementListe<T>* vratiElement(int i) const{
			if(i<0 || i>Velicina())
				return NULL;
			if(i==0)
				return vratiPocetak();
			ElementListe<T>* tekuci = _pocetak;
			for(int k = 0; k < i; k++)
				tekuci = tekuci->vratiSledeci();	
			return tekuci;
		}
		
		// Funkcija dodaje na pocetak novi element sa vrednoscu n
		void DodajNaPocetak( const T& n ){
			// Napravimo novi element liste i njega postavljamo za novi pocetak 
			_pocetak = new ElementListe<T>( n, _pocetak );
			_velicina++;
		}

		// Funkcija dodaje na kraj novi element sa vrednoscu n
		void DodajNaKraj( const T& n ){
			// Napravimo novi element
			ElementListe<T>* novi = new ElementListe<T>( n, NULL );
			// Ako je lista do sada bila prazna, kraj je ujedno i pocetak liste
			if( !_pocetak )
				_pocetak = novi;
			else{
			// Ako lista nije bila prazna, potrazimo poslednji element liste
				ElementListe<T>* p = _pocetak;
				for( ; p->vratiSledeci(); p=p->vratiSledeci() );
				// p je poslednji element liste za koji vezujemo novi kraj 
				p->postaviSledeci(novi);
			}
			_velicina++;
		}
		
		void obrisiSaPocetka(){
			if(vratiPocetak() == NULL)
				return;
			ElementListe<T>* tekuci = vratiPocetak()->vratiSledeci();
			delete _pocetak;
			_pocetak = tekuci;
			_velicina--;
		}
		
		void obrisiSaKraja(){
			if(vratiPocetak() == NULL)
				return;
			ElementListe<T>* prethodni = _pocetak;
			ElementListe<T>* tekuci = vratiPocetak()->vratiSledeci();
			while(tekuci->vratiSledeci()){
				prethodni = tekuci;
			 	tekuci=tekuci->vratiSledeci();
			}
			// tekuci je poslednji cvor liste, koji brisemo
			prethodni->postaviSledeci(NULL);
			delete tekuci;
			_velicina--;
		}
	
		/* Funkcija vraca velicinu liste */
		int Velicina() const{
			return _velicina;
		}

		/* Implicitno definisan operator = ponasa se slicno implicitno definisanom konstruktoru kopije po tome sto izvodi plitko kopiranje liste. Da bi se pri dodeljivanju izvodilo duboko kopiranje, neophodno je da u operatoru dodeljivanja uradimo prakticno isti posao kao i u konstruktoru kopije liste. 
		Da bi primene operatora dodeljivanja mogle da se nadovezuju, uobicajeno je da on vrati kao rezultat referencu na izmenjen objekat. */
		Lista& operator = ( const Lista& l ){
		/* proveravamo da li je u pitanju isti objekat, tj. da nije u pitanju situacija x=x, u tom slucaju ne vrsimo kopiranje (sa &l dobijamo adresu objekta na koji l referise pa to poredimo sa this ) */ 
			if( this != &l ){
		/* potrebno je prvo unistiti stari sadrzaj liste pa tek onda uraditi kopiranje, tj. dodelu novog sadrzaja, inace bi stari sadrzaj trajno ostao zaboravljen u memoriji */ 
				deinit();	
				init(l);
			}
			/* this je pokazivac, *this objekat klase Lista */
			return *this;
		}
		
		void ispisi(std::ostream& ostr) const{
			ElementListe<T> * tekuci = _pocetak;
			ostr << "( ";
			while(tekuci){
				ostr << tekuci->vratiVrednost() << " ";
				tekuci = tekuci->vratiSledeci();
			}
			ostr << ") ";
		}

	private:
		/* Funkciju init koristimo prilikom definisanja konstruktora kopije i operatora = posto imaju slicnu logiku dubokog kopiranja objekata */
		void init( const Lista& l ){
			// Proveravamo da li je lista prazna
			if( l._pocetak ){
				// Iskopiramo prvi element
				_pocetak = new ElementListe<T>( *l._pocetak );
				ElementListe<T>* stari = l._pocetak;
				ElementListe<T>* novi = _pocetak;
				// Kopiramo naredne elemente, sve dok postoje u listi 
				while( stari->vratiSledeci() ){
					novi->postaviSledeci( new ElementListe<T>( *stari->vratiSledeci()));
					// Azuriramo tekuce elemente liste 
					novi = novi->vratiSledeci();
					stari = stari->vratiSledeci();
				}
			}
			// Ako je pocetna lista prazna, takva ce biti i njena kopija
			else
				_pocetak = NULL;
			_velicina = l._velicina;
		}

		/* Funkcija deinit koristimo prilikom definisanja destruktora i operatora = za unistavanje prethodnog sadrzaja liste pre same dodele novog sadrzaja */
		void deinit(){
			ElementListe<T>* p = _pocetak;
			for( ; p; ){
			/* Sacuvamo pokazivac na ostatak liste, pa pozovemo podrazumevani destruktor za tekuci element, za ElementListe nije potrebno definisati destruktor jer objekte ove klase posmatramo u okviru objekta klase Lista koja vodi racuna o pravilnom oslobadjanju memorije za svoje elemente */ 
				ElementListe<T>* p1 = p->vratiSledeci();
				delete p;
				p = p1;
			}
			_velicina=0;
		}
		
		/* Lista cuva kao podatak pokazivac na pocetak */
		ElementListe<T>* _pocetak;
		int _velicina;
};

}
/* Sablonski operator << za prikaz liste na standardnom izlazu. */
template <typename T>
std::ostream & operator << (std::ostream & ostr, const kolekcija::Lista<T> & lista){
	lista.ispisi(ostr);
	return ostr;
}
#endif  

