#ifndef NIZ_H
#define NIZ_H
#include <iostream>

/* u prostoru imena kolekcija cemo definisati razlicite kolekcije podataka, medju kojima je i dinamicki niz, a kasnije cemo dodati i listu */
namespace kolekcija{

template <class T>
class Niz{
	public:
		Niz(int n){
			init(n);
		}
		Niz(const Niz& niz){
			init(niz._n, niz._niz);
		}
		~Niz(){
			deinit();
		}
		int duzina() const{
			return _n;
		}
		const T& prvi() const{
			if(duzina()==0)
				return _nula;
			return (*this)[0];
		}
		const T& poslednji() const{
			if(duzina()==0)
				return _nula;
			return (*this)[duzina()-1];
		}
		void dodajNaKraj(const T& el){
			/* ako nema dovoljno mesta povecavamo niz */
			if(_n+1 > _alocirano)
				povecanjeNiza(_n+1);
			else
				/* ako ima dovoljno mesta, samo povecamo duzinu */
				_n = _n+1;
			(*this)[_n-1] = el; 
		}
		
		void dodajNaPocetak(const T& el){
			/* ako nema dovoljno mesta povecavamo niz */
			if(_n+1 > _alocirano)
				povecanjeNiza(_n+1);
			else
				/* ako ima dovoljno mesta, samo povecamo duzinu */
				_n = _n+1;
			/* pomeramo za jednu poziciju u desno sve elemente
			 moramo sa kraja poceti jer bi inace prepisali stare elemente */
			for (int i=duzina()-2; i>=0; i--) {
				(*this)[i+1] = (*this)[i];
			}
			(*this)[0] = el;
		}

		int obrisiPoslednji(){
			if(duzina()<1)
				return 0;
			/* poslednji "brisemo" tako sto na njegovu poziciju postavimo podrazumevanu vrednost za tip T 
			 i smanjimo duzinu niza */
			(*this)[duzina()-1] = T();
			_n = _n - 1;
			return 1;
		}
		
		int obrisiPrvi(){
			if(duzina()<1)
				return 0;
			/* pomeramo za jednu poziciju u levo sve elemente
			 time cemo prekopirati prvi element */
			for (int i=1; i<duzina(); i++) {
				(*this)[i-1] = (*this)[i];
			}
			/* onaj poslednji je prebacen na poziciju levo, ali 
			 treba unistiti njegovu kopiju i smanjiti duzinu niza */
			(*this)[duzina()-1] = T();
			_n = _n - 1;
			return 1;
		}

		Niz& operator = (const Niz& n){
			/* ako nije dodela oblika nizA = nizA */
			if (this != &n){
				deinit();
				init(n._n, n._niz);
			}
			/* vracamo referencu na nas niz da bi omogucili uzastopne dodele tipa nizA = nizB = nizC */
			return *this;
		}
		/* vracamo referencu na i-ti element niza, a ukoliko takav ne postoji 
		 povecavamo niz */
		T& operator [] (int i){
			if(i >= duzina())
				povecanjeNiza(i+1);
			return _niz[i];
		}
		/* kada se poziva operator [] za konstantne objekte, ne dozvoljavamo izmene */
		const T& operator [] (int i) const{
			/* u slucaju da takvog elementa nema, vracamo referencu na "nulu" */
			if(i >= duzina())
				return _nula;
			return _niz[i];
		}
		void ucitaj(std::istream& istr){
			for (int i = 0; i<_n; i++){
				istr>>_niz[i];
			}
		}

		void ispisi(std::ostream& ostr) const{
			for (int i = 0; i<_n; i++)
				ostr << i+1 << ". " << _niz[i] << std::endl;
		}
		
	private:
		/* metod init kao opcioni argument ima pokazivac na niz elemenata,
		 ovaj argument se ne koriste u konstruktoru Niz(int), ali ga koristimo 
		 u konstruktoru kopiranja i operatoru = */
		void init(int n, const T* niz = NULL){
			_n = n;
			_alocirano = 2*n;
			_niz = new T[2*n];
			/* potrebno je inicijalizovati pocetne vrednosti u nizu ako je pozvan init bez drugog argumenta
			 jer new to ne radi po difoltu */
			if(niz==NULL){
				for (int i = 0; i < n; i++){
				/* podrazumevani konstruktor za klasne tipove se poziva, a za
				primitivne se postavlja 0 */
					_niz[i] = T();
				}
			}
			else
				/* ukoliko je prosledjen niz koeficijenata, kopiramo ga */
				for (int i = 0; i < n; i++){
					_niz[i] = niz[i];
				}
		}
		void deinit(){
			delete [] _niz;
		}
		/* Povecavanje niza je skupa operacija jer
		 p *odrazumeva prepisivanje celog niza. Zbog toga
		 prilikom obezbedjujemo vecu kolicinu memorije 
		 nego sto je u datom trenutku neophodno, kako ne 
		 bismo uskoro morali ponovo da prepisujemo
		 ceo niz, ovaj metod pozivaju samo clanovi klase
		 pa je privatan */
		void povecanjeNiza(int n)
		{
			/* povecavamo niz samo ako je zatrazeno povecanje vece od 
			 broja trenutno alociranih */
			if(n>_alocirano){
				/* sacuvamo stari niz */
				Niz pom(*this);
				/* brisemo stare elemente */
				deinit();
				/* pravimo novi niz dimezije n, init uradi inicijalizaciju */
				init(n);
				/* ostalo je kopirati stare elemente niza u novi */
				for (int i = 0; i < pom._n; i++)
					_niz[i] = pom._niz[i];
				
			}
		}
		
		/* razlikujemo broj alociranih i broj zauzetih elemenata u nizu (to je n)
		  ideja je da uvek pri kreiranju niza alociramo vise elemenata, na primer duplo od 
		  trazene duzine, da se prilikom dodavanja novih elemenata ne bi uvek sve prepisivalo, 
		  vec samo kad se dostigne broj alociranih mesta */
		int _n; // broj zauzetih mesta, tj. duzina niza 
		int _alocirano;
		T* _niz;
		/* staticki clan klase, inicijalizuje se podrazumevanom vrednoscu za primitivne tipove 
		 ili se, u slucaju klasnog tipa, poziva podrazumevani konstruktor */
		static const T _nula;
};

/* staticki clan klase treba inicijalizovati van klase, jer to nije deo objekta */
template <typename T>
const T Niz<T>::_nula = T();


/* sablonske funkcije i operatori za rad sa sablonskim nizovima */
template <typename T>
T maksimalni( const Niz<T>& niz){	
	if(niz.duzina()==0)
		return T();	
	T max = niz[0];
	for (int i = 1; i < niz.duzina(); i++)
		if (max < niz[i])
			max = niz[i];
	return max;
}
template <typename T>
T prosek( const Niz<T>& niz){
	if(niz.duzina()==0)
		return T();		
	T s = niz[0];
	for (int i =1; i < niz.duzina(); i++)
			s = niz[i] + s;
	return s/niz.duzina();
}

}
/* operatori >> i << su predefinisani izvan naseg prostora imena pa je neophodan prefiks za pristup klasi Niz */
template <typename T>
std::istream& operator >> (std::istream & istr, kolekcija::Niz<T>& niz){
	niz.ucitaj(istr);
	return istr;
} 
template <typename T>
std::ostream& operator << (std::ostream & ostr, const kolekcija::Niz<T>& niz){
	niz.ispisi(ostr);
	return ostr;
} 

#endif
