#include <iostream>
#include<list>

/* Sekvencijalni kontejner:
 list<T> -- dvostruko povezana lista. Omogucava efikasno dodavanje i 
 uklanjanje elemenata sa pocetka i sa kraja, kao i bilo gde u sredini
 liste. Medjutim, ne poseduje indeksni operator [], tako da nemate 
 direktan pristup elementima liste. Jedini mehanizam za rad sa elementima
 liste su iteratori. Dodavaje i brisanje se vrsi pomocu metoda insert()
 i erase() kojima se predaje iterator (a insert-u i vrednost koja se
 dodaje). insert() dodaje element ispred tekuceg iteratora, dok erase()
 brise element na koji pokazuje iterator. */

int main(){
	
	std::list<int> l; // prazna lista (slicni konstruktori kao i kod vektora)
	int n;
	std::cin >> n;
	while(n!=0){
		l.push_front(n); // dodaje element na pocetak liste
		std::cin >> n;
	}	
	/* primetimo da je u listi:
	
	 l.push_back(n);
	 
	 ekvivalentno sa:
	 
	 l.insert(l.end(), n); // dodaje ispred nepostojeceg elementa koji je
	 // iza poslednjeg, sto znaci, na kraj
	 
	 dok je:
	 
	 l.push_front(n);
	 
	 ekvivalentno sa:
	 
	 l.insert(l.begin(), n); // ispred prvog, sto znaci na pocetak
	 
	 */
	
	/* Pomocu iteratora ispisujemo ucitane elemente, s obzirom da ne modifikujemo listu
	 koristimo const_iterator */
	std::list<int>::const_iterator it;
	if(l.size()!=0){
		std::cout << "Uneli ste brojeve:" << std::endl;
		for(it = l.begin(); it != l.end(); it++){
			std::cout << *it  << " ";
		}
		std::cout << std::endl;
		
		int broj;
		std::cout << "Unesite broj na osnovu kog treba modifikovati kolekciju:"<< std::endl;
		std::cin >> broj;
		
		/* Koristimo iterator za brisanje elemenata vecih od unetog broja, ne sme biti const jer se preko 
		 * njega modifikuje lista */
		std::list<int>::iterator eit;
		int i;
		for(eit = l.begin(), i=0; eit != l.end();i++){
			if(*eit>broj)
				eit = l.erase(eit); // brise element liste na koji pokazuje eit i vraca iterator 
				// na sledeci element liste (iza obrisanog)	
				else
					eit++; // ako nije u ovoj iteraciji obrisan element, pomeramo iterator
		}
		std::cout << "Kolekcija posle brisanja elemenata:" << std::endl;
		for(it = l.begin(); it != l.end(); it++){
			std::cout << *it  << " ";
		}
		std::cout << std::endl;
	}
	else
		std::cout << "Niste uneli nijedan broj." << std::endl;
}	
	
