#include<iostream>
#include<set>

/* Asocijativni kontejneri:

set<T> -- predstavlja skup elemenata tipa T. Podrzava efikasno dodavanje
novog elementa u skup, brisanje elementa iz skupa i proveru da li se 
neka vrednost nalazi u skupu. Sve sto je potrebno je da tip T ima definisan
operator <. Interno je klasa set implementirana obicno preko
uravnotezenog stabla, tako da je ogranicenje slozenosti za sve pomenute
operacije logaritamsko. Iteracijom kroz skup (pomocu iteratora) obilazi
se stablo sa leva na desno, tako da dobijamo elemente u rastucem poretku.

multiset<T> -- slicno kao set, samo sto dozvoljava ponavljanje elemenata. */

int main(){

	std::set<int> s; // prazan skup
	int n;
	std::cin >> n;
	while(n!=0){
		s.insert(n); // insert dodaje element u skup ukoliko on vec ne postoji
								// inace vraca iterator na taj element
		std::cin >> n;
	}
	if(s.size()!=0){
		/* Pomocu iteratora ispisujemo ucitane elemente, posto je u pitanju skup
		 elementi ce biti ispisani u rastucem poretku */
		std::cout << "Elementi niza u rastucem poretku:" << std::endl;
		std::set<int>::const_iterator it;
		for(it = s.begin(); it != s.end(); it++){
			 std::cout << *it  << " ";
		}
		std::cout << std::endl;
		/* Da bismo ispisali elemente u opadajucem poretku koristicemo reverse_iterator */
		std::cout << "Elementi niza u opadajucem rastuce:" << std::endl;
		std::set<int>::const_reverse_iterator rit;
		for(rit = s.rbegin(); rit != s.rend(); rit++){
			std::cout << *rit  << " ";
		}
		std::cout << std::endl;
	}
	 else
		 std::cout << "Niste uneli nijedan broj." << std::endl;

}