#include<iostream>
#include<map>
#include<string>

using std::cout;
using std::cin;
using std::endl;

/* Sekvencijalni kontejneri:
 
 map<T> -- predstavlja kolekciju parova (kljuc, vrednost), pri cemu se 
 p retraga uvek vrsi po kljucu. Zapravo, *mapa u stvari predstavlja skup
 parova koji su u C++-u implementirani pomocu pomocne klase pair<T1, T2>
 koja sadrzi dva javna podatka clana first (tipa T1) i second (tipa T2) koji
 predstavljaju respektivno prvu i drugu komponentu uredjenog para. U mapi
 se ovakvi parovi koriste za cuvanje parova (kljuc, vrednost). Iteracijom
 kroz mapu mi dobijamo iteratore koji pokazuju na odgovarajuci par, a onda
 pomocu first i second pristupamo kljucu i vrednosti. Interno, mapa je takodje
 implementirana pomocu stabla. Mapa ima i ugradjen operator [] koji za 
 indeks uzima podatak tipa kljuca, a vraca podatak koji predstavlja vrednost
 pridruzenu datoj vrednosti kljuca. Ukoliko dati kljuc ne postoji u mapi,
 tada ga operator [] automatski kreira i postavlja mu pridruzenu vrednost
 na podrazumevanu vrednost (ako postoji definisan podrazumevani konstruktor).
 Ako ovo nije ono sto zelimo, mozemo koristiti metodu find() koja nam vraca
 iterator na element ako postoji, a end() iterator ako element ne postoji 
 u mapi, slicno kao i kod skupa.
 
 multimap<T> -- slicno kao map, samo dopusta ponavljanje kljuca, tj. da jednom
 kljucu bude pridruzeno vise vrednosti. */

int main(){
	
	int n; 
	cout<<"Unesite koliko studenata ima baza:"<<endl;
	cin>>n;
	/* Mapa studenti kao kljuc ima korisnicka imena studenata sa alas-a, a kao
	vrednost ima prosecnu ocenu studenta. */
	std::map<std::string, double> studenti; // prazna mapa
	cout<<"Unesite podatke o studentima:"<<endl;
	for(int i=0;i<n;i++){
			std::string korisnik;
			double prosek;
			cin >> korisnik >> prosek;
			// Mapa je kolekcija parova, tako da se insert-om dodaju parovi sa 
			// odgovarajucim komponentama koristeci klasu std::pair 
			// koja kao clanove ima dva objekta ne striktno istog tipa 
			studenti.insert(std::pair<std::string, double>(korisnik, prosek));
			// Ili ovako (sablonska funkcija make_pair() automatski pravi odgovarajuci
			// par, uz dedukciju odgovarajucih tipova) :
			// 
			// studenti.insert(make_pair(korisnik, prosek);
	}
	std::string s;
	cout << "Unesite korisnicko ime studenta ciji prosek zelite: ";
	cin >> s;
	std::map<std::string, double>::iterator it = studenti.find(s);  // dajemo mu kljuc
	/* find vraca iterator koji pokazuje na par (string, double) koji za kljuc ima 
	vrednost s, ili vraca studenti.end() kao indikator da ne postoji par sa tim kljucem */
	if(it != studenti.end()){
		/* it->first je kljuc, it->second vrednost pridruzena kljucu */
		cout << "Student " << it->first << " ima prosek: " << it->second << endl;
		cout << "Unesite njegov novi prosek ili 0 ako ne zelite da menjate: "<<endl;
		double prosek;
		cin >> prosek;
		if(prosek!=0){
			it->second = prosek;  // moglo je i odmah cin >> it->second;
			cout << "Novi prosek studenta " << it->first << " je: " << it->second << endl;
		}
	}
	else{
		cout << "Student ne postoji u bazi." << endl;
		cout << "Ako zelite da dodate studenta " << s << "u bazu unesite njegov prosek ili 0 ako ne zelite da menjate sadrzaj baze."<<endl;
		double prosek;
		cin >> prosek;
		if(prosek!=0){
			studenti[s] = prosek;  // kada nema elementa prosledjenim kljucem, automatski ga ubacuje, uz podrazumevanu 
			                     // vrednost (0 za double), a u ovom slucaju ga doda u mapu i postavi vrednost na prosek
			cout << "Student " << s << " sa prosekom " << studenti[s] << " je uspesno dodat u bazu." << endl;
		}	
	}
	
}
