#include <iostream>
#include <vector>
#include <string>

using std::vector;
using std::string;

/* sablonska funkcija za ispis vektora */
template <typename T>
void ispisi(const vector<T>& v){
	/* i iterator je genericki, tj. ima parametar */
	for(typename vector<T>::const_iterator it=v.begin(); it!=v.end(); it++){
		std::cout<< *it << std::endl;
	}
}

/* sablonska funkcija za ucitavanje vektora */
template <typename T>
void ucitaj(vector<T> &v, int n){
	T x;
	for(int i=0; i<n; i++){
		std::cin>>x;
		v.push_back(x);
	}
}

/* sablonska funkcija koja primenjuje operacije sabiranja i oduzimanja nad prvim vektorom,
 ukoliko je T klasni tip, neophodno je da u su u toj klasi definisani operatori + i - */
template <typename T>
T transformisi(const vector<T>& v1, const vector<string>& v2){
	typename vector<T>::const_iterator it1 = v1.begin();
	vector<string>::const_iterator it2 = v2.begin();
	T rezultat = *it1; // smestamo prvi element u rezultat
	it1++; //pomerimo se na sledeci element 
	while(it2!=v2.end()){
		/* proveravamo koja je operacija u pitanju */
		if((*it2) == "+")
			rezultat = rezultat + (*it1);
		else
			rezultat = rezultat - (*it1);
		/* pomeramo se na sledeci element u oba vektora */
		it1++;
		it2++;
	}
	return rezultat;
}

int main(){
	int n;
	std::cout << "Unesite duzinu vektora celih brojeva"<<std::endl;
	std::cin >> n;
	vector<int> vI;
	std::cout << "Unesite vektor celih brojeva"<<std::endl;
	ucitaj(vI, n);
	std::cout << "Uneli ste vektor"<<std::endl;
	ispisi(vI);
	vector<string> vO; // vektor stringova koji predstavljaju operacije + i -
	std::cout << "Unesite vektor operacija + i - razvojenih razmakom"<<std::endl;
	ucitaj(vO, n-1);
	std::cout << "Uneli ste operacije"<<std::endl;
	ispisi(vO);
	int rezI = transformisi(vI, vO);
	std::cout << "Rezultat primene operacija nad vektorom je: "<< rezI << std::endl;
	vO.clear(); // brise sadrzaj vektora i velicinu postavlja na 0
	
	std::cout << "Unesite duzinu vektora realnih brojeva"<<std::endl;
	std::cin >> n;
	vector<float> vF;
	std::cout << "Unesite vektor celih brojeva"<<std::endl;
	ucitaj(vF, n);
	std::cout << "Uneli ste vektor"<<std::endl;
	ispisi(vF);
	std::cout << "Unesite vektor operacija + i - razvojenih razmakom"<<std::endl;
	ucitaj(vO, n-1);
	std::cout << "Uneli ste operacije"<<std::endl;
	ispisi(vO);
	float rezF = transformisi(vF, vO);
	std::cout << "Rezultat primene operacija nad vektorom je: "<< rezF << std::endl;
	
}

