#ifndef MATRICA_H
#define MATRICA_H

#include <iostream>
#include <vector>

/* u zaglavlju <algorithm> su definisani sabloni funkcija koji implementiraju pretrazivanje, uredjivanje, inicijalizovanje i jos mnogo drugih funkcija za rad 
 sa razlicitim kolekcijama iz STL-a */ 

#include <algorithm>

namespace algebra{

/* Kvadratna matrica reda N se predstavlja kao vektor vrsta, odnosno vektor dimenzije N ciji su elementi vektori dimenzije N koji predstavljaju vrste matrice */ 
template <class T>
class Matrica{
	public:
		Matrica(unsigned n): _Elementi(std::vector< std::vector<T> >(n)){
			/* inicijalizujemo vrste matrice */
			for(unsigned i = 0; i<n; i++)
				_Elementi[i] = std::vector<T>(n);
		}
		unsigned red() const{
			return _Elementi.size();
		}
		/* metod koji vraca zbir elemenata na glavnoj dijagonali matrice
		 ukoliko je T klasni tip, neophodno je da je definisan operator +
		 za objekte klase T, vracamo objekat tipa T, a ne referencu jer 
		 je zbir lokalna promenljiva */
		const T dijagonala()const{
			/* na dijagonali su elementi ciji je indeks kolone jednak indeksu vrste u matrici */
			T zbir = T();
			for (unsigned i = 0; i < red(); i++)
				zbir = zbir + _Elementi[i][i];
			return zbir;
		}
		/* metod vraca referencu na maksimalni element matrice
		 koristicemo funkciju max_element definisanu u zaglavlju <algorithm> 
		 koja ima sledeci potpis Iterator max_element (Iterator first, terator last)
		 funkcija kao povratnu vrednost ima iterator koji pokazuje na element 
		 sa najvecom vrednoscu u opsegu [first, last), ako ima vise takvih, vraca se 
		 iterator na prvi maksimalni
		 neophodno je da za tip elemenata matrice bude definisan operator < 
		 */
		const T max_m()const{
			if(red()==1)
				return _Elementi[0][0];
			/* matrica je vektor vrsta, pa trazimo maksimum medju maksimumima vrsta 
			pretpostavimo da je maksimum matrice jednak maksimumu prve vrste */
			T maks = *std::max_element(_Elementi[0].begin(), _Elementi[0].end());
			for(unsigned i=1;i<red();i++){
				T maksv = *std::max_element(_Elementi[i].begin(), _Elementi[i].end());
				if(maks < maksv)
					maks = maksv;
			}
			/* vracamo maksimum od nadjenih maksimuma po vrstama */
			return maks;
		}
		/* operator [] koji vraca referencu
		 na odgovarajuci vektor vrste matrice i 
		 dozvoljava izmenu date vrste, ukoliko takva
		 vrsta ne postoji, vraca se referenca na _nulaVrsta
		 tj. prazan vektor */
		std::vector<T>& operator[] ( unsigned i ){
			if(i>red())
				return _nulaVrsta;
			return _Elementi[i];
		}
		/* operator [] koji vraca referencu
		na odgovarajuci vektor vrste matrice, ali ne
		dozvoljava izmenu date vrste, ukoliko takva
		 vrsta ne postoji, vraca se referenca na _nulaVrsta
		 tj. prazan vektor  */
		const std::vector<T>& operator[] ( unsigned i ) const{
			if(i>red())
				return _nulaVrsta; 
			return _Elementi[i];
		}
		/* metod koji pravi transponat matrice */
		Matrica napraviTransponat() const{
			/* Transponat matrice M je matrica MT cije su vrste jednake kolonama matrice M */
			Matrica MT(red());
			for (unsigned i = 0; i < red(); i++){
				/* element aij matrice M je jednak elementu aji matrice MT */
				for(unsigned j = 0; j < red(); j++)
					MT[j][i] = (*this)[i][j]; 
			}
			return MT;
		}
		void ucitaj(std::istream& istr){
			/* broj vrsta i kolona je jednak redu matrice */
			for (unsigned i = 0; i < red(); i++){
				for(unsigned j = 0; j < red(); j++ ){
					istr >> _Elementi[i][j];
				}
			}
		}
		/* metod koji ispisuje za matricu njen transponat */
		void ispisiTransponat() const{
			/* Transponat matrice M je matrica MT cije su vrste jednake kolonama matrice M */
			for (unsigned j = 0; j < red(); j++){
				/* ispisujemo j-tu kolonu, sto predstavlja j-tu vrstu transponata */
				for( unsigned i = 0; i < red(); i++ )
					std::cout << _Elementi[i][j] << " "; 
				std::cout<<std::endl;
			}
		}
		void ispisi(std::ostream& ostr) const{
			/* indeksni pristup elementima vektora je efikasan */
			for (unsigned i = 0; i < red(); i++){
				for( unsigned j = 0; j < red(); j++ )
					ostr << _Elementi[i][j] << " "; 
				ostr<<std::endl;
			}
		}
	private:
		std::vector< std::vector<T> > _Elementi;
		static std::vector<T> _nulaVrsta;
};

/* staticki clan mora biti inicijalizovan izvan klase jer on nije deo objekata klase */
template <typename T> std::vector<T> Matrica<T>::_nulaVrsta;

}

template <typename T>
std::istream& operator >> (std::istream &istr, algebra::Matrica<T>& m){
  m.ucitaj(istr);
  return istr;
} 
template <typename T>
std::ostream& operator << (std::ostream & ostr, const algebra::Matrica<T>& m){
  m.ispisi(ostr);
  return ostr;
} 


#endif
