#include "Trougao.h"

namespace geometrija{

/* prazan konstruktor, ako njega ne definisemo, naredba 

	Trougao t;

prijavljuje gresku, jer se tu poziva podrazumevani konstruktor */

Trougao::Trougao():_a(2.0), _b(3.0), _c(4.0){ 

} 

/* Za trougao treba da bude ispunjeno da je svaka stranica kraca od zbira druge dve i da je svaka stranica veca od razlike druge dve stranice tog trougla.
Funkcija je deklarisana u klasi kao static jer prakticno nije vezana za objekat klase Trougao i moze biti pozvana i kad ne postoji objekat nase klase. Koristimo je u konstruktoru i kad korisnik pokusava da promeni vrednosti podacima. U static funkcijama ne mozemo koristiti this pokazivac, prilikom definicije ne stavljamo static */
bool Trougao::provera(double a, double b, double c){
	if(a < b + c && b < a + c && c < a + b && a > fabs(b - c) && b > fabs(a - c) && c > fabs(a - b))
		return true;
	else
		return false;
}

void Trougao::postavi(double a, double b, double c){
	/* ne dozvoljavamo promenu ukoliko provera ne prodje */
	if(Trougao::provera(a,b,c)){
			_a = a;
			_b = b;
			_c = c;
	}
	else{
		/* ukoliko neki od uslova nije ispunjen, postavljaju se podrazumevane vrednosti 2, 3, 4 */
			_a = 2.0;
    	_b = 3.0;
    	_c = 4.0;
	} 	
}

Trougao::Trougao(double a, double b, double c){ 
	postavi(a,b,c);
}

double Trougao::vratiA() const{
	return _a;
}
  
double Trougao::vratiB() const{
	return _b;
}

double Trougao::vratiC() const{
	return _c;
}

/* Funkcije clanice klase mogu pristupati drugim clanovima iste klase
 p ri cemu se uvek podrazumevano misli *na clanove koji pripadaju
 objektu klase za koji je ta funkcija clanica i pozvana. Ovo se
 ostvaruje putem implicitnog pokazivaca na objekat klase za koji
 je funkcija pozvana, a koji se uvek predaje funkciji clanici kao
 implicitni (skriveni) argument. Unutar tela funkcije clanice,
 njemu se uvek moze pristupiti pomocu kljucne reci this. Ovu 
 kljucnu rec najcesce nije neophodno koristiti, jer se ona 
 podrazumeva, ako se ne kaze drugacije (npr kada napisemo _a,
 prevodilac to razume kao this->_a. */
double Trougao::obim() const{
	return vratiA() + vratiB() + vratiC();
}
  
  /* Svaka funkcija clanica klase se opciono moze kvalifikovati 
	 k ao konstantna, a to se radi dodavanjem kljucne reci const n*akon
	 zaglavlja funkcije, a pre definicije tela funkcije. Ovim se naznacava
	 da metoda nece menjati objekat klase za koji se poziva. Unutar
	 ovih metoda se prosto pokazivac this smatra pokazivacem na konstantan
	 objekat te klase (u nasem slucaju this je tipa "const Trougao *"). 
	 Ovo sprecava npr. dodelu _a = 2; jer se _a implicitno tumaci kao this->_a
	 a this je pokazivac na konstantan objekat klase Trougao. Funkcije clanice
	 koje su oznacene sa const se mogu pozivati za bilo koji objekat klase,
	 s obzirom da se pokazivac na nekonstantan objekat uvek moze konvertovati
	 u pokazivac na konstantan objekat. Sa druge strane, metode koje nisu 
	 oznacene kao konstantne se ne mogu pozivati za objekte koji su konstantni
	 (ili se u datom kontekstu smatraju konstantnim), zato sto bi to zahtevalo
	 konverziju iz pokazivaca na konstantan objekat u pokazivac na nekonstantan
	 objekat (s ozbirom da se this unutar nekonstantnih metoda tumaci kao 
	 pokazivac na nekonstantan objekat). 
	 
	 Tipicno, metode za postavljanje vrednosti clanova klase nisu konstantne,
	 dok metode za ocitavanje vrednosti clanova klase to jesu. */
double Trougao::povrsina() const{
	/* Poziv obim() se tumaci kao this->obim(). Ova metoda se ne bi mogla 
	 pozvati da nije obelezena kao const, s obzirom da je povrsina() 
	 konstantna metoda, tj. this je pokazivac na konstantan Trougao. */ 
	double s = obim() / 2;
	return sqrt(s * (s - vratiA()) * (s - vratiB()) * (s - vratiC()));
}
  
double Trougao::poluprecnikUpisanog() const{
	double s = obim() / 2;
	double P = povrsina();
	return P / s;
}
  
double Trougao::poluprecnikOpisanog() const{
	return vratiA() * vratiB() * vratiC() / (4 * povrsina());
}

/* Metode mogu kao argumente imati druge objekte istog klasnog tipa.
  Unutar metode se clanovima tih drugih objekata pristupa preko njihovih
  identifikatora (tj. t.obim() ili t->obim() ako je t pokazivac na Trougao)
  Metoda ima prava da pristupa i privatnim clanovima drugih objekata, zato
  sto su u pitanju objekti iste klase.
 */
bool Trougao::imaVeciObimOd(const Trougao & t) const{
	/* obim() se odnosi na ovaj objekat (this->obim()), dok se t.obim() odnosi
	 na objekat na koji referise t */
	return obim() > t.obim();
}
	
/* postoji mogucnost redefinisanja operatora, u nasem primeru, trouglove poredimo po povrsini kada koristimo operatore <, ==, > */
bool Trougao::operator < ( const Trougao& t ) const{
	return povrsina() < t.povrsina();
} 
bool Trougao::operator == ( const Trougao& t ) const{
	return povrsina() == t.povrsina();
}

bool Trougao::operator > ( const Trougao& t ) const{
	return povrsina() > t.povrsina();
}

Trougao Trougao::operator + ( const Trougao& t ) const{
	return Trougao(vratiA() + t.vratiA(), vratiB() + t.vratiB(), vratiC() + t.vratiC());
}


/* Primer operatora koji se ne moze definisati unutar klase Trougao, zato
 s to mu je levi operand objekat druge klase (*klase ostream) koja je
 definisana u biblioteci i mi u nju ne mozemo dodavati nove operatore.
 Zbog toga se definise na spoljasnjem nivou, sa dva parametra koji 
 odgovaraju redom levom i desnom operandu. */
std::ostream& operator << (std::ostream& ostr, const Trougao& t){
	ostr << "(" << t.vratiA() << ", " << t.vratiB() << ", " << t.vratiC() << ")";
	/* Operator << ciji je levi operand objekat klase ostream uvek vraca referencu na sam objekat klase ostream za koju je i pozvan. Na taj nacin se omogucava nadovezivanje operatora << prilikom ispisa, s obzirom na levu asocijativnost ovog operatora. Referenca na ostream nema kvalifikator const, zato sto se prilikom ispisa interno stanje ostream objekta menja (sto bi bilo spreceno kada bismo ga kvalifikovali kao const). */
	return ostr;
}

std::istream& operator >> (std::istream& istr, Trougao& t){
	double a, b, c;
	istr >> a >> b >> c;
	t.postavi(a,b,c);
	return istr;
}


}
