package forma_za_unos;

import javafx.application.Application;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.PasswordField;
import javafx.scene.control.TextField;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.paint.Color;
import javafx.scene.text.Font;
import javafx.scene.text.Text;
import javafx.stage.Stage;

/*
 * Forme za unos obicno imaju tabelarnu organizaciju komponenti, pa nam odgovara kontejner za 
 * komponente GridPane  tabelarna organizacija komponenti (kao matrica)
 */

public class FormaZaUnos extends Application {

	@Override
	public void start(Stage stage) throws Exception {
		GridPane osnova = new GridPane();
		/*
		 * postavljamo poziciju kontejnera i unutrasnje margine
		 */
		osnova.setAlignment(Pos.CENTER);
		osnova.setVgap(10);
		osnova.setHgap(10);
		osnova.setPadding(new Insets(10, 10, 10, 10));

		Text naslov = new Text("Dobrodosli");
		naslov.setFont(new Font(20));
		/*
		 * 0-ta kolona, 0-ti red 2 oznacava da se komponenta prostire preko 2
		 * kolone 1 oznacava da se prostire po 1 redu to je podrazumevano
		 */
		osnova.add(naslov, 0, 0, 2, 1);
		/*
		 * za korisnika dodajemo labelu i tekstualno polje u koje unosi
		 * korisnicko ime
		 */
		Text k_lab = new Text("Korisnicko ime:");
		osnova.add(k_lab, 0, 1);
		TextField k_tekst = new TextField();
		osnova.add(k_tekst, 1, 1);
		/*
		 * dodajemo labelu i tekstualno polje za lozinku - uneti karakteri nisu
		 * vidljivi
		 */
		Text l_lab = new Text("Password:");
		osnova.add(l_lab, 0, 2);
		PasswordField l_tekst = new PasswordField();
		osnova.add(l_tekst, 1, 2);

		/*
		 * labela za ispis poruke nakon uspesnog prijavljivanja
		 */
		final Text uspesno = new Text("");
		uspesno.setFill(Color.RED);
		osnova.add(uspesno, 0, 4, 2, 1);
		/*
		 * dugme za potvrdu prijavljivanja
		 */
		Button dugme = new Button("Prijavi se.");
		/*
		 * HBox - sve komponente u jednom redu VBox - sve komponente u jednoj
		 * koloni
		 */
		HBox hb = new HBox();
		hb.setAlignment(Pos.CENTER_RIGHT);
		hb.getChildren().add(dugme);
		osnova.add(hb, 1, 3);

		dugme.setOnAction(new EventHandler<ActionEvent>() {

			@Override
			public void handle(ActionEvent arg0) {
				uspesno.setText("Uspesno prijavljivanje.");
			}
		});

		Scene scene = new Scene(osnova, 300, 300);
		stage.setScene(scene);
		stage.show();
	}

	public static void main(String[] args) {
		Application.launch(args);
	}

}
