package liste;

import java.util.Arrays;
import java.util.Comparator;

import javafx.application.Application;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Pos;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.ListView;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;

public class Lista extends Application {

	@Override
	public void start(Stage stage) throws Exception {
		/*
		 * za prikaz liste nam odgovara kontejnet VBox - komponente se
		 * postavljaju u jednu kolonu
		 */
		VBox osnova = new VBox();
		osnova.setAlignment(Pos.CENTER);
		/*
		 * pravimo genericku listu koja je inicijalno prazna, a model podataka
		 * se postavlja preko setItems() metoda
		 */
		ListView<String> lista = new ListView<String>();
		final ObservableList<String> imena = FXCollections
				.observableArrayList();
		imena.addAll(Arrays.asList("Petar", "Ana", "Mira", "Marko", "Jovana"));
		/*
		 * dodajemo podatke
		 */
		lista.setItems(imena);
		osnova.getChildren().add(lista);
		Button dugme = new Button("Sortiraj");
		dugme.setOnAction(new EventHandler<ActionEvent>() {

			@Override
			public void handle(ActionEvent event) {
				imena.sort(new Comparator<String>() {
					@Override
					public int compare(String o1, String o2) {
						return o1.compareTo(o2);
					}
				});
			}
		});
		osnova.getChildren().add(dugme);

		Scene scena = new Scene(osnova, 200, 400);
		stage.setScene(scena);
		stage.show();
	}

	public static void main(String[] args) {
		Application.launch(args);
	}

}
