package pozdrav;

import javafx.application.Application;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.layout.StackPane;
import javafx.stage.Stage;

/*
 * Naslediti klasu javafx.application.Application
 */
public class PozdravFX extends Application {

	@Override
	public void start(Stage stage) throws Exception {
		/*
		 * u metodu start() koji se pokrece kad se pozove launch() dodajemo
		 * graficke komponente za nasu aplikaciju
		 */
		Button dugme = new Button("Reci Zdravo :)");
		/*
		 * reagovanje na dogadjaj
		 */
		dugme.setOnAction(new EventHandler<ActionEvent>() {

			@Override
			public void handle(ActionEvent arg0) {
				System.out.println("Zdravo :)");
			}
		});
		/*
		 * kontejner za komponente StackPane - komponente se dodaju jedna iznad
		 * druge razvuceno
		 */
		StackPane osnova = new StackPane();
		/*
		 * dodavanje komponente u kontejner
		 */
		osnova.getChildren().add(dugme);
		/*
		 * priprema scene sa zadatim dimenzijama i datim kontejnerom komponenti
		 */
		Scene scena = new Scene(osnova, 300, 300);
		/*
		 * postavljanje scene na pozornicu i prikazivanje
		 */
		stage.setScene(scena);
		stage.show();
	}

	public static void main(String[] args) {
		/*
		 * Aplikaciju pokrecemo pozivom metoda launch()
		 */
		Application.launch(args);
	}

}
