package slajder;

import javafx.application.Application;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Pos;
import javafx.scene.Scene;
import javafx.scene.control.Slider;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.FlowPane;
import javafx.scene.shape.Circle;
import javafx.scene.text.Text;
import javafx.stage.Stage;

/*
 * Vrednost slajdera definise precnik kruga koji se prikazuje u centru.
 */
public class SlajderKrug extends Application {

	@Override
	public void start(Stage stage) throws Exception {
		/*
		 * BorderPane  kontejner za komponente koji se sastoji iz 5 regiona
		 * (gornji, donji, levi, desni, centar)
		 */
		BorderPane osnova = new BorderPane();
		/*
		 * FlowPane  kontejner u kome se komponente dodaju sa leva na desno,
		 * odozgo na dole
		 */
		FlowPane top = new FlowPane();
		top.setAlignment(Pos.CENTER);

		Text lab = new Text("Velicina precnika:");
		top.getChildren().add(lab);
		/*
		 * prva dva argumenta u konstruktoru se odnose na min i max vrednost
		 * koja se prikazuje pomocu slajdera, a treci argument je pocetna
		 * vrednost koja ce biti prikazana pri pokretanju aplikacije
		 */
		Slider slajder = new Slider(0, 100, 0);
		slajder.setShowTickLabels(true);
		slajder.setBlockIncrement(1);
		top.getChildren().add(slajder);
		final Circle krug = new Circle(0);
		osnova.setCenter(krug);

		slajder.valueProperty().addListener(new ChangeListener<Number>() {
			public void changed(ObservableValue<? extends Number> ov,
					Number old_val, Number new_val) {
				/*
				 * kako se vrednost na slajderu menja, tako se i velicina
				 * precnika kruga koji se prikazuje u centru menja
				 */
				krug.setRadius((Double) new_val);
			}
		});

		osnova.setTop(top);

		Scene scene = new Scene(osnova, 500, 500);

		stage.setScene(scene);
		stage.show();
	}

	public static void main(String[] args) {
		Application.launch(args);
	}

}
