package liste;


import javafx.application.Application;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Pos;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.ListView;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;

public class DveListe extends Application {

	@Override
	public void start(Stage stage) throws Exception {
		HBox osnova = new HBox();
		osnova.setAlignment(Pos.CENTER);
		Scene scena = new Scene(osnova, 500, 400);

		final ListView<String> listaImena1 = new ListView<String>();
		final ObservableList<String> imena1 = FXCollections.observableArrayList(
				"Marko", "Jana", "Petar", "Milica", "Zeljko");
		listaImena1.setItems(imena1);
		final ListView<String> listaImena2 = new ListView<String>();
		final ObservableList<String> imena2 = FXCollections.observableArrayList(
				"Ljubica", "Andrea", "Milan", "Darko", "Djordje");
		listaImena2.setItems(imena2);

		osnova.getChildren().add(listaImena1);
		/*
		 * dugme koje prebacuje ime iz leve u desnu listu
		 */
		Button dugmeLD = new Button(">>");
		dugmeLD.setMinWidth(100);
		dugmeLD.setOnAction(new EventHandler<ActionEvent>() {
			@Override
			public void handle(ActionEvent event) {
				/*
				 *  prebacujemo ono ime koje je selektovano
				 */
				int idx=listaImena1.getSelectionModel().getSelectedIndex();
				if(idx>=0){
					String ime = imena1.get(idx);
					imena1.remove(idx);
					imena2.add(ime);
				}
			}
		});
		/*
		 * dugme koje prebacuje ime iz desne u levu listu
		 */
		Button dugmeDL = new Button("<<");
		dugmeDL.setMinWidth(100);
		dugmeDL.setOnAction(new EventHandler<ActionEvent>() {
			@Override
			public void handle(ActionEvent event) {
				int idx=listaImena2.getSelectionModel().getSelectedIndex();
				if(idx>=0){
					String ime = imena2.get(idx);
					imena2.remove(idx);
					imena1.add(ime);
				}
			}
		});

		VBox sredina = new VBox();
		sredina.setAlignment(Pos.CENTER);
		sredina.getChildren().add(dugmeLD);
		sredina.getChildren().add(dugmeDL);
		osnova.getChildren().add(sredina);

		osnova.getChildren().add(listaImena2);

		stage.setScene(scena);
		stage.show();
	}

	public static void main(String[] args) {
		Application.launch(args);
	}

}
