package cas;

import javafx.application.Application;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Pos;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.Slider;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.FlowPane;
import javafx.scene.layout.GridPane;
import javafx.scene.text.Text;
import javafx.stage.Stage;

/*
 * Vrednost slajdera definise dimenziju matrice koja predstavlja tablicu mnozenja (max=9).
 */
public class SlajderMatrica extends Application {

	@Override
	public void start(Stage stage) throws Exception {
		/*
		 * BorderPane  kontejner za komponente koji se sastoji iz 5 regiona
		 * (gornji, donji, levi, desni, centar)
		 */
		BorderPane osnova = new BorderPane();
		/*
		 * FlowPane  kontejner u kome se komponente dodaju sa leva na desno,
		 * odozgo na dole
		 */
		FlowPane top = new FlowPane();
		top.setAlignment(Pos.CENTER);

		Text lab = new Text("Velicina tablice mnozenja");
		top.getChildren().add(lab);
		/*
		 * prva dva argumenta u konstruktoru se odnose na min i max vrednost
		 * koja se prikazuje pomocu slajdera, a treci argument je pocetna
		 * vrednost koja ce biti prikazana pri pokretanju aplikacije
		 */
		Slider slajder = new Slider(0, 9, 0);
		slajder.setShowTickLabels(true);
		slajder.setBlockIncrement(1);
		top.getChildren().add(slajder);

		/*
		 * dugmice dodajemo u mrezu koju postavljamo na osnovu
		 */
		final GridPane grid = new GridPane();
		grid.setAlignment(Pos.CENTER);
		osnova.setCenter(grid);

		slajder.valueProperty().addListener(new ChangeListener<Number>() {
			public void changed(ObservableValue<? extends Number> ov,
					Number old_val, Number new_val) {
				grid.getChildren().clear();
				/*
				 * kako se vrednost na slajderu menja, tako se i dimenzije
				 * matrice menjaju
				 */
				for (int i = 1; i <= new_val.intValue(); i++)
					for (int j = 1; j <= new_val.intValue(); j++)
					{
						Button dugme = new Button("(" + i + "," + j + ")");
						grid.add(dugme, j, i);
						final int di = i;
						final int dj = j;
						dugme.setOnAction(new EventHandler<ActionEvent>() {
							
							@Override
							public void handle(ActionEvent arg0) {
								// TODO Auto-generated method stub
								System.out.println(di+" * "+dj+" = "+di*dj);
							}
						});
					}
				}
		});

		osnova.setTop(top);

		Scene scene = new Scene(osnova, 500, 500);

		stage.setScene(scene);
		stage.show();
	}

	public static void main(String[] args) {
		Application.launch(args);
	}

}
