package cas_2;

import java.util.Random;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.Condition;

public class Banka3 {
	private Klijent[] klijenti;
	private Random rg;
	private ReentrantLock katanac;
	/*
	 * uslovni redovi cekanja omogucavaju da se niti koje ne ispunjavaju neki
	 * uslov za ulazak u kriticnu sekciju blokiraju i ne smetaju drugim nitima,
	 * u nasem primeru ih koristimo da ne bi bile dozvoljene transakcije sa
	 * racuna na kom nema dovoljno novca odnosno, ne dozvoljavamo da stanje na
	 * racunu ide u minus
	 */
	private Condition dovoljnoNovca;

	public Banka3() {
		rg = new Random();
		katanac = new ReentrantLock();
		/* uslovni red cekanja je vezan za konkretan katanac */
		dovoljnoNovca = katanac.newCondition();
		klijenti = new Klijent[100];
		for (int i = 0; i < klijenti.length; i++)
			klijenti[i] = new Klijent(i, 100, this);
		for (int i = 0; i < klijenti.length; i++)
			klijenti[i].start();
	}
	public Klijent[] getKlijenti() {
		return klijenti;
	}

	public Random getRg() {
		return rg;
	}

	public void setKlijenti(Klijent[] klijenti) {
		this.klijenti = klijenti;
	}

	public void setRg(Random rg) {
		this.rg = rg;
	}

	public void setKatanac(ReentrantLock katanac) {
		this.katanac = katanac;
	}

	public ReentrantLock getKatanac() {
		return katanac;
	}

	void transfer(int id1, int id2, int kolicina) {
		katanac.lock();
		/*
		 * kada nit udje u kriticnu sekciju, blokira se na ovom uslovu dok god
		 * ga ne ispuni, tj. nema potrebe da krece sa izvrsavanjem transfera
		 * novca, ako novca nema dovoljno.
		 */
		while (kolicina > klijenti[id1].getStanje())
			try {
				/* tekuca nit se suspenduje sve dok uslov nije ispunjen */
				dovoljnoNovca.await();
			} catch (InterruptedException e) {
				e.printStackTrace();
			}
		klijenti[id1].setStanje(klijenti[id1].getStanje() - kolicina);
		klijenti[id2].setStanje(klijenti[id2].getStanje() + kolicina);
		System.out.printf("%d %d (%d->%d) Total: %d\n",
				klijenti[id1].getStanje(), kolicina, id1, id2, total());
		/*
		 * signalAll nakon zavrsetka transfera obavestava druge niti koje cekaju
		 * na dovoljnoNovca listi cekanja da probaju da udju u kriticnu sekciju,
		 * jer su mozda ispunile uslov (posto je ova nit bas nekom od njih
		 * prebacila novac koji im je dovoljan da sada oni izvrse transfer ka
		 * nekom trecem racunu)
		 */
		dovoljnoNovca.signalAll();
		katanac.unlock();
	}

	/*
	 * funkcija total() racuna ukupan zbir svih depozita u banci
	 */
	int total() {
		int total = 0;
		for (int i = 0; i < klijenti.length; i++)
			total += klijenti[i].getStanje();
		return total;
	}

	public static void main(String[] args) {
		Banka3 bank = new Banka3();
	}
}

/*
 * svaki klijent predstavlja jednu nit, metod run() poziva funkciju transfer()
 * koja vrsi prebacivanje novca sa jednog na drugi racun u banci
 */
class Klijent extends Thread {
	private int id;
	private int stanje;
	private Banka3 banka;

	public Klijent(int id, int stanje, Banka3 banka) {
		this.id = id;
		this.stanje = stanje;
		this.banka = banka;
	}
	@Override
	public long getId() {
		return super.getId();
	}

	public void setId(int id) {
		this.id = id;
	}

	public Banka3 getBanka() {
		return banka;
	}

	public void setBanka(Banka3 banka) {
		this.banka = banka;
	}

	public int getStanje() {
		return stanje;
	}

	public void setStanje(int stanje) {
		this.stanje = stanje;
	}


	@Override
	public void run() {
		super.run();
		while (true) {
			int id2 = banka.getRg().nextInt(100);
			int kolicina = banka.getRg().nextInt(100);
			banka.transfer(id, id2, kolicina);
			try {
				sleep(10);
			} catch (InterruptedException e) {
				e.printStackTrace();
			}
		}
	}
}
