package LanacIshrane;

import java.awt.Color;
import java.awt.Graphics;
import java.util.Random;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

/* njiva je deljeni resurs, ali obnovljivi, tako da i ona treba da bude nit */
public class Njiva extends Thread implements Drawable {
	
	private int x, y, w, h;
	private int kapacitet;
	private Panel panel;
	private ReentrantLock lock = new ReentrantLock();
	private Condition isEmpty = lock.newCondition();
	private Random rand = new Random();

	public Njiva(int x, int y, int w, int h, int kapacitet, Panel panel) {
		super();
		this.x = x;
		this.y = y;
		this.w = w;
		this.h = h;
		this.kapacitet = kapacitet;
		this.panel = panel;
		this.start();
	}

	public void run() {
		super.run();
		/* njiva donosi 10 glavica na 10 sekundi */
		while (true) {
			/*
			 * posto je deljeni resurs, zakljucavamo deo gde menjamo kapacitet
			 * njive
			 */
			lock.lock();
			/* poveca kapacitet */
			kapacitet += 10;
			/* signaliziramo zecevima koji cekaju jer nije bilo dovoljno kupusa */
			isEmpty.signalAll();
			lock.unlock();
			panel.repaint();
			try {
				/* odspava 10 sekundi */
				Thread.sleep(10 * 1000);
			} catch (InterruptedException e) {
				e.printStackTrace();
			}
		}
	}

	/*
	 * kada je na njivi, zec uzima 1 ili 2 glavice kupusa ili ceka ukoliko nema
	 * dovoljno
	 */
	public void sell(Zec zec) {
		lock.lock();
		int i = 1 + rand.nextInt(2);
		while (kapacitet < i)
			try {
				isEmpty.await();
			} catch (Exception e) {
				e.printStackTrace();
			}
		kapacitet -= i;
		lock.unlock();
	}

	public void draw(Graphics g) {
		g.setColor(Color.green);
		g.fillRect(x, y, w, h);
		g.setColor(Color.YELLOW);
		g.drawString("" + kapacitet, x + w / 2, y + h / 2);

	}

	/*
	 * metod proverava da li je zec na njivi, tj. da li su koordinate zeca
	 * unutar pravougaonika koji predstavlja njiva
	 */
	public boolean contains(int x2, int y2) {
		/*
		 * x2, y2 su koordinate gornjeg levog ugla kvadrata u koji je upisan
		 * krug precnika 10 kojim je predstavljan zec
		 */
		return (x2 + Zec.r >= x && x2 <= x + w && y2 + Zec.r >= y && y2 <= y
				+ h);
	}

	public int getX() {
		return x;
	}

	public int getW() {
		return w;
	}

	public int getY() {
		return y;
	}

	public int getH() {
		return h;
	}
}
