package LanacIshrane;

import java.awt.Dimension;
import java.awt.Graphics;
import java.util.ArrayList;
import java.util.Random;

import javax.swing.JPanel;

public class Panel extends JPanel {

	private Random randGen = new Random();
	private Zec zecevi[] = new Zec[20];
	private Vuk vukovi[] = new Vuk[2];
	private ArrayList<Drawable> drawables = new ArrayList<Drawable>();
	private Njiva njiva;
	private Boolean ok;

	public Panel(int w, int h) {
		super();
		setPreferredSize(new Dimension(w, h));
		njiva = new Njiva(150, 250, 100, 100, 0, this);

		Zec.r = 5;
		for (int i = 0; i < 20; i++) {
			ok = false;
			Zec zec = null;
			while (!ok) {
				zec = new Zec(randGen.nextInt(w - 2 * Zec.r), randGen.nextInt(h
						- 2 * Zec.r), this);
				/* zec ne sme da se kreira da bude na njivi */
				if (!this.njiva.contains(zec.getX(), zec.getY()))
					ok = true;
			}
			/*
			 * kad je kreiran zec sa lokacijom van njive dodajemo ga u niz
			 * zeceva
			 */
			zecevi[i] = zec;
		}
		Vuk.r = 20;
		for (int i = 0; i < 2; i++) {
			ok = false;
			Vuk vuk = null;
			while (!ok) {
				vuk = new Vuk(randGen.nextInt(w - 2 * Vuk.r), randGen.nextInt(h
						- 2 * Vuk.r), this);
				/* vuk ne sme da se kreira da bude na njivi */
				if (!this.njiva.contains(vuk.getX(), vuk.getY())
						&& this.naisaonazeca(vuk.getX(), vuk.getY()) == null)
					ok = true;
			}
			/*
			 * kad je kreiran vuk sa lokacijom van njive dodajemo ga u niz
			 * vukova
			 */
			vukovi[i] = vuk;
		}
		/*
		 * prvo dodajemo njivu zbog redosleda crtanja objekata, inace ako se
		 * njiva doda na kraj, zecevi i vukovi koji prelaze preko njive ne bi
		 * bili vidljivi na panelu
		 */
		drawables.add(njiva);
		/* pokrecemo sve niti i dodajemo u niz objekata za crtanje */
		for (Zec s : zecevi) {
			drawables.add(s);
			s.start();
		}
		for (Vuk s : vukovi) {
			drawables.add(s);
			s.start();
		}
	}

	public void paint(Graphics g) {
		super.paint(g);
		for (Drawable d : drawables)
			d.draw(g);
	}

	public Zec naisaonazeca(int x, int y) {
		for (Zec zec : zecevi)
			if (zec.contains(x, y))
				return zec;
		return null;
	}

	public Njiva getNjiva() {
		return njiva;
	}
}
