package LanacIshrane;

import java.awt.Color;
import java.awt.Graphics;

public class Vuk extends Thread implements Drawable {

	private int x, y, dx = 2, dy = 2;
	private Panel panel;
	static int r;

	public Vuk(int x, int y, Panel panel) {
		super();
		this.x = x;
		this.y = y;
		this.panel = panel;
	}

	public void run() {
		super.run();
		while (true) {
			move();
			panel.repaint();
			try {
				Thread.sleep(10);
			} catch (InterruptedException e) {
				e.printStackTrace();
			}
		}
	}

	private void move() {
		/* metod vraca na kog je zeca vuk naisao ili null */
		Zec zec = panel.naisaonazeca(x, y);
		if (zec != null) {
			zec.setObrisi(true);
		}
		/* ukoliko je naisao na granicu panela */
		if (x <= 0 || x + 2 * r >= panel.getWidth())
			dx *= -1;
		if (y <= 0 || y + 2 * r >= panel.getHeight())
			dy *= -1;
		x += dx;
		y += dy;

	}

	public void draw(Graphics g) {
		g.setColor(Color.BLACK);
		/* visina i sirina kruga su jednake precniku, tj. 2*r */
		g.fillOval(x, y, 2 * r, 2 * r);
	}

	public int getX() {
		return x;
	}

	public int getY() {
		return y;
	}
}
