package LanacIshrane;

import java.awt.Color;
import java.awt.Graphics;

public class Zec extends Thread implements Drawable {
	/*
	 * indikator koji nam sluzi da zaustavljanje niti i ujedno da se taj zec
	 * vise ne crta na panelu kad ga vuk pojede
	 */
	private Boolean obrisi = false;
	private int x, y;
	static int r;
	private Panel panel;
	private int dx = 1;
	private int dy = 1;

	public Zec(int x, int y, Panel panel) {
		super();
		this.x = x;
		this.y = y;
		this.panel = panel;
	}

	private void move() {
		Boolean nanjivi = panel.getNjiva().contains(x, y);
		if (nanjivi == true) {
			/* ako je na njivi, hrani se kupusom */
			panel.getNjiva().sell(this);
			/* odbija se pod istim uglom od njive */
			if (x < panel.getNjiva().getX()
					|| panel.getNjiva().getX() + panel.getNjiva().getW() < x)
				dx *= -1;
			if (y < panel.getNjiva().getY()
					|| panel.getNjiva().getY() + panel.getNjiva().getH() < y)
				dy *= -1;
		}
		/* ako nailazi na granicu panela, odbija se pod istim uglom od njega */
		if (x <= 0 || x + 2 * r >= panel.getWidth())
			dx *= -1;
		if (y <= 0 || y + 2 * r >= panel.getHeight())
			dy *= -1;
		x += dx;
		y += dy;

	}

	public void run() {
		super.run();
		/* sve dok ga vuk nije pojeo */
		while (!obrisi) {
			move();
			panel.repaint();
			try {
				Thread.sleep(10);
			} catch (InterruptedException e) {
				e.printStackTrace();
			}
		}
	}

	public boolean contains(int x2, int y2) {
		/*
		 * vuk i zec su predstavljeni krugovima precnika 40 i 10 redom, ova dva
		 * kruga se seku ili dodiruju ukoliko je duz koja spaja njihove centre
		 * manja ili jednaka zbiru njihovih poluprecnika
		 */
		int xrZeca = x + r;
		int yrZeca = y + r;
		int xrVuka = x2 + Vuk.r;
		int yrVuka = y2 + Vuk.r;
		return Math.sqrt((xrZeca - xrVuka) * (xrZeca - xrVuka)
				+ (yrZeca - yrVuka) * (yrZeca - yrVuka)) <= r + Vuk.r;
	}

	public int getX() {
		return x;
	}

	public int getY() {
		return y;
	}

	public void setObrisi(Boolean obrisi) {
		this.obrisi = obrisi;
	}

	public void draw(Graphics g) {
		if (!obrisi) {
			g.setColor(Color.BLUE);
			/* visina i sirina kruga su jednake precniku, tj. 2*r */
			g.fillOval(x, y, 2 * r, 2 * r);
		}
	}
}
