package cas_3;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.util.ArrayList;
import java.util.Random;

import javax.swing.JPanel;

public class Panel extends JPanel {
	/* lista objekata za crtanje, to ce biti stanice i vozovi */
	private ArrayList<Drawable> drawables = new ArrayList<>();
	private Stanica[] stanice = new Stanica[7];
	private int[][] Veza = new int[7][7];
	private Voz[] vozovi = new Voz[5];
	private Random rand = new Random();

	public Panel(int w, int h) {
		super();
		setPreferredSize(new Dimension(w, h));
		/* kreiramo stanice na osnovu podataka sa slike */
		stanice[0] = new Stanica(50, 50, 30, 15);
		stanice[1] = new Stanica(400, 50, 40, 25);
		stanice[2] = new Stanica(500, 150, 60, 30);
		stanice[3] = new Stanica(500, 300, 30, 15);
		stanice[4] = new Stanica(400, 300, 40, 15);
		stanice[5] = new Stanica(50, 300, 50, 30);
		stanice[6] = new Stanica(50, 250, 30, 15);

		for (int i = 0; i < 7; i++)
			drawables.add(stanice[i]);
		
		for (int i = 0; i < 5; i++) {
			int r = rand.nextInt(7);
			vozovi[i] = new Voz(stanice[r].getX(), stanice[r].getY(), this);
			vozovi[i].start();
			drawables.add(vozovi[i]);
		}
		/* citamo podatke iz date matrice povezanosti na slici */ 
		Veza[0][1] = 1;
		Veza[1][2] = 1;
		Veza[2][3] = 1;
		Veza[3][4] = 1;
		Veza[2][4] = 1;
		Veza[4][5] = 1;
		Veza[5][6] = 1;
		Veza[6][0] = 1;
		Veza[0][4] = 1;

	}
	public Stanica[] getStanice() {
		return stanice;
	}
	public Voz[] getVozovi() {
		return vozovi;
	}
	public int[][] getVeza() {
		return Veza;
	}
	public Random getRand() {
		return rand;
	}
	public ArrayList<Drawable> getDrawables() {
		return drawables;
	}
	/* ukoliko postoji stanica na lokaciji (x,y) vraca njen indeks, inace -1 */ 
	public int getStanica(int x, int y) {
		int i;
		for (i = 0; i < 7; i++)
			if (stanice[i].contains(x, y))
				return i;
		return -1;
	}
	
	public void paint(Graphics g1) {
		super.paint(g1);
		int i, j;
		for (Drawable d : drawables)
			d.draw(g1);
		g1.setColor(Color.BLUE);
		for (i = 0; i < 7; i++)
			for (j = 0; j < 7; j++)
				if (Veza[i][j] == 1)
					g1.drawLine(stanice[i].getX(), stanice[i].getY(),
							stanice[j].getX(), stanice[j].getY());
	}
}
