package cas_3;

import java.awt.Color;
import java.awt.Graphics;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

public class Stanica implements Drawable {
	private int x;
	private int y;
	private int kapacitet;
	private int stanje;
	private Panel p;
	private ReentrantLock rlock = new ReentrantLock();
	/*
	 * potrebne su nam dve kondicione liste, kad voz pokusava da napuni svoje
	 * vagone do punog kapaciteta, a stanica nema dovoljno robe i obratna
	 * situacija kada voz pokusava da istovari svoju robu u stanicu koja nema
	 * dovoljno mesta u skladistu da primi tu robu
	 */
	private Condition kupi = rlock.newCondition();
	private Condition prodaj = rlock.newCondition();

	public Stanica(int x, int y, int kapacitet, int stanje) {
		super();
		this.x = x;
		this.y = y;
		this.kapacitet = kapacitet;
		this.stanje = stanje;
	}

	public int getStanje() {
		return stanje;
	}

	public int getKapacitet() {
		return kapacitet;
	}

	public int getX() {
		return x;
	}

	public int getY() {
		return y;
	}

	public Panel getP() {
		return p;
	}

	private void prodaja(Voz voz) {
		rlock.lock();
		/*
		 * u stanici nema dovoljno robe, voz ceka
		 */
		while (stanje < voz.getKapacitet())
			try {
				prodaj.await();
			} catch (Exception e) {
				e.printStackTrace();
			}
		stanje -= voz.getKapacitet();
		/* voz je preuzeo robu is stanice */
		voz.setFull(true);
		/*
		 * saljemo signal vozovima koji cekaju da istovare svoju robu u stanicu
		 * da je promenjeno stanje
		 */
		kupi.signalAll();
		rlock.unlock();
	}

	private void kupovina(Voz voz) {
		rlock.lock();
		/*
		 * voz pokusava da istovari robu, ali u stanici nema dovoljno prostora
		 */
		while (stanje + voz.getKapacitet() > kapacitet)
			try {
				kupi.await();
			} catch (InterruptedException e) {
				e.printStackTrace();
			}
		stanje += voz.getKapacitet();
		/* voz je istovario svoju robu */
		voz.setFull(false);
		/*
		 * saljemo signal vozovima koji cekaju da preuzmu robu da je promenjeno
		 * stanje
		 */
		prodaj.signalAll();
		rlock.unlock();
	}

	public void razmena(Voz voz) {
		/*
		 * ako je pristigao pun voz, pokusava se kupovina, u suprotnom, prodaja
		 * robe
		 */
		if (voz.isFull())
			kupovina(voz);
		else
			prodaja(voz);
	}

	@Override
	public void draw(Graphics g1) {
		g1.setColor(Color.GRAY);
		g1.fillRect(x, y, kapacitet, kapacitet - stanje);
		g1.setColor(Color.BLUE);
		g1.fillRect(x, y + kapacitet - stanje, kapacitet, stanje);
		g1.setColor(Color.WHITE);
		g1.drawString(stanje + "", x + kapacitet / 2, y + kapacitet / 2);
	}

	public boolean contains(int x2, int y2) {
		return (x2 == x && y2 == y);
	}
}
