package cas_3;

import java.awt.Color;
import java.awt.Graphics;
import java.util.Random;

public class Voz extends Thread implements Drawable {
	/*
	 * x i y predstavljaju koordinate voza, dok dx i dy pomeraj pri kretanju
	 */
	private int x, y, dx, dy;
	private int kapacitet;
	private Random rand = new Random();
	private Panel panel;
	private boolean full = false;

	public Voz(int x, int y, Panel panel) {
		super();
		this.x = x;
		this.y = y;
		this.kapacitet = rand.nextInt(6) + 5;
		this.panel = panel;
	}

	public int getKapacitet() {
		return kapacitet;
	}

	@Override
	public void run() {
		super.run();
		while (true) {
			move();
			/*
			 * posle pomeranja treba osveziti panel da bi se azurirale pozicije
			 * voza i stanje u stanicama
			 */
			panel.repaint();
			try {
				sleep(30);
			} catch (InterruptedException e) {
				e.printStackTrace();
			}

		}
	}

	private void move() {
		/*
		 * vozovi se krecu u smeru skazaljke na satu jer je u suprotnom velika
		 * verovatnoca da se voz "zaglavi" izmedju dve stanice
		 */
		/* proveravamo da li je voz u nekoj stanici */
		int i = panel.getStanica(x, y);
		if (i != -1) {
			/*
			 * ako je u stanici, pokusava razmenu sa njom (stanica odredjuje na
			 * osnovu toga da li je pristigao pun ili prazan voz kakvu razmenu
			 * pokusava)
			 */
			Stanica s = panel.getStanice()[i];
			s.razmena(this);
			/* ako je u 1. stanici, krece se ka 2. po dijagonali kvadrata */
			if (i == 1) {
				dx = 1;
				dy = 1;
			} else if (i == 3) {
				/* krece se ka 4. po x osi u suprotnom smeru */
				dx = -1;
				dy = 0;
			} else if (i == 5 || i == 6) {
				/* krece se po y osi u suprotnom smeru */
				dx = 0;
				dy = -1;
			} else if (i == 0) {
				/* krece se ka 1. ili 4. stanici */
				if (Math.random() < 0.5) {
					/*
					 * ka 4. stanici ide po dijagonali pravougaonika dimenzije
					 * 350x250 pa odnos pomeraja dx i dy treba da bude isti kao
					 * odnos duzina stranica
					 */
					dx = 7;
					dy = 5;
				} else {
					/* ka 1. stanici se krece po x osi u istom smeru */
					dx = 1;
					dy = 0;
				}
			} else if (i == 2) {
				/* krece se ka 3. ili 4. stanici */
				if (Math.random() < 0.5) {
					/*
					 * ka 4. stanici se krece po dijagonali pravougaonika
					 * dimenzije 100x150
					 */
					dy = 3;
					dx = -2;
				} else {
					/* ka 3. stanici se krece po y osi u istom smeru */
					dx = 0;
					dy = 1;
				}
			} else if (i == 4) {
				/* krece se ka 0. ili 2. ili 5. stanici */
				double rg = Math.random();
				if (rg <= 0.3) {
					/* ka 5. stanici se krece po x osi u suprotnom smeru */
					dx = -1;
					dy = 0;
				} else if (rg > 0.3 && rg <= 0.6) {
					/*
					 * ka 0. stanici ide po dijagonali pravougaonika dimenzije
					 * 350x250 pa odnos pomeraja dx i dy treba da bude isti kao
					 * odnos duzina stranica
					 */
					dx = -7;
					dy = -5;
				} else if (rg > 0.6) {
					/* ka 2. stanici se krece po x osi u istom smeru */
					dy = -3;
					dx = 2;
				}
			}
			x += dx;
			y += dy;
		}
		/*
		 * azuriramo koordinate voza, ako je bio na stanici, nasumicno je
		 * izabrana sledeca stanica ka kojoj se krece, ako nije bio na stanici,
		 * koristice se stari dx i dy, tj. voz ce nastaviti istim kolovozom
		 */
		x += dx;
		y += dy;
	}

	@Override
	public void draw(Graphics g1) {
		g1.setColor(Color.RED);
		if (isFull())
			g1.fillRect(x, y, kapacitet, 10);
		else
			g1.drawRect(x, y, kapacitet, 10);

	}

	public boolean isFull() {
		return full;
	}

	public void setFull(boolean full) {
		this.full = full;
	}

}
