// prevodjenje programa: g++ 7.cpp Osoba.cpp

#include <iostream>
#include "Osoba.h"

template<typename T>
T* napravi(int n){
	//new je zamena za dinamicku alokaciju u c-u (malloc) i vraca pokazivac na alociran blok
	return new T[n];
}
template<typename T>
void ispisi(const T* niz, int n){
	for(int i=0; i<n; i++)
		std::cout<<niz[i]<< std::endl;
}
template<typename T>
void ucitaj(T* niz, int n){
	for(int i=0; i<n; i++)
		std::cin>>niz[i];
}
/* sablon sa opcionim argumentom, ako se ne prosledi dimenzija niza pozdrazumeva se da ima 2 elementa */
template <typename T>
T maksimum( T* niz, int n = 2){
	T maks = niz[0];
	for(int i=1; i<n; i++)
		if(maks<niz[i])
			maks = niz[i];
	return maks;
}

int main(){
	int n;
	int *nizInt;
	float *nizFloat;
	vrsta::Osoba *nizOsoba;
	std::cout<<"Dimenzija niza: ";
	std::cin>>n;
	
	nizInt = napravi<int>(n);
	nizFloat = napravi<float>(n);
	nizOsoba = napravi<vrsta::Osoba>(n);
	std::cout<<"Unesite "<<n<<" celih brojeva"<< std::endl;
	ucitaj<int>(nizInt, n);
	std::cout<<"Unesite "<<n<<" realnih brojeva"<< std::endl;
	ucitaj<float>(nizFloat, n);
	std::cout<<"Unesite "<<n<<" osoba u obliku ime prezime godina_rodjenja"<< std::endl;
	ucitaj<vrsta::Osoba>(nizOsoba, n);
	ispisi<int>(nizInt, n);
	ispisi<float>(nizFloat, n);
	ispisi<vrsta::Osoba>(nizOsoba, n);
	
	if(n==2){
		std::cout<<"Maksimum u nizu celih brojeva je: "<<maksimum<int>(nizInt)<< std::endl;
		std::cout<<"Maksimum u nizu realnih brojeva je: "<<maksimum<float>(nizFloat)<< std::endl;
		std::cout<<"Najmladja osoba (maksimalna godina rodjenja) u nizu Osoba je: "<<maksimum<vrsta::Osoba>(nizOsoba)<< std::endl;
	}
	else{
		std::cout<<"Maksimum u nizu celih brojeva je: "<<maksimum<int>(nizInt,n)<< std::endl;
		std::cout<<"Maksimum u nizu realnih brojeva je: "<<maksimum<float>(nizFloat,n)<< std::endl;
		std::cout<<"Najmladja osoba (maksimalna godina rodjenja) u nizu Osoba je: "<<maksimum<vrsta::Osoba>(nizOsoba,n)<< std::endl;
	}
	delete [] nizInt;
	delete [] nizFloat;
	delete [] nizOsoba;	
	
}
