#ifndef KOORDINATE_H
#define KOORDINATE_H
#include <iostream>

namespace tacka{
	/* Pored sablona funkcija, u C++-u postoje i sabloni klasa. Sablon klase moze imati jedan ili vise tipskih parametara koji se mogu koristiti u definiciji klase na svakom mestu gde se ocekuje ime tipa (kao tipovi clanova klase, kao tipovi parametara ili povratni tipovi funkcija clanica, kao tipovi lokalnih promenljivih funkcija clanica, ...). Ako je definicija klase sablonska, tada su i svi njeni clanovi implicitno sablonski. Sablon klase se definise na sledeci nacin:
	 * 
	 *   template < lista_tipskih_parametara >
	 *   definicija_klase;
	 * 
	 * gde je lista_tipskih_parametara lista zarezima razdvojenih tipskih parametara
	 *   oblika:
	 *   
	 *   typename ID
	 * 
	 *   ili 
	 * 
	 *   class ID
	 * 
	 * gde je ID proizvoljni identifikator. Sablon klase ne definise klasu, vec definise "recept" po kome se moze napraviti klasa, kada se specificiraju konkretni tipovi kojima ce biti zamenjeni tipski parametri. Ovaj proces se zove instanciranje sablona klase i njegov rezultat je konkretna klasa nastala iz sablona. Klase nastale iz istog sablona sa razlicitim vrednostima tipskih parametara su razlicite klase koje nemaju nikakve veze jedna sa drugom. Instanciranje sablona klase vrsi se na sledeci nacin:
	 * 
	 *   ImeKlase<Tip1,Tip2,...,Tipn>
	 * 
	 * gde su Tip1,Tip2,... konkretni tipovi koji se dodeljuju odgovarajucim parametrima sablona. ImeKlase bez navodjenja konkretnih tipova ne predstavlja konkretnu klasu vec sablon, pa samim tim ga nije moguce koristiti na mestima gde se ocekuje tip:
	 * 
	 *   ImeKlase x; // greska: ne zna se koja instanca sablona je u pitanju 
	 *   
	 * Izuzetak od ovoga je koriscenje imena sablona unutar same definicije sablona klase. Kada se ImeKlase koristi unutar definicije klase (ili njenih clanova), tada se podrazumeva da je u pitanju ista instanca sablona kao i ona u kojoj se ImeKlase koristi */
	
template <class T>
class Koordinate{
	public:
		Koordinate():_x(T()), _y(T()), _z(T()){
		}
		
		Koordinate(const T& x,const T& y,const T& z): _x(x), _y(y), _z(z){
		
		}
		/* pristupne metode */
		const T& X() const{
			return _x;		
		}
		const T& Y() const{
			return _y;		
		}
		const T& Z() const{
			return _z;		
		}
		/* metode za postavljanje podataka */
		void postaviX( const T& x){
			_x = x;		
		}
		void postaviY( const T& y){
			_y = y;		
		}
		void postaviZ( const T& z){
			_z = z;		
		}		
		/* poredimo rastojanja od koordinatnog pocetka */
		bool operator < (const Koordinate& k) const{
			return X() * X() + Y() * Y() + Z() * Z() < k.X() * k.X() + k.Y() * k.Y() + k.Z() * k.Z();
		}
		bool operator == (const Koordinate& k) const{
			return X() * X() + Y() * Y() + Z() * Z() == k.X() * k.X() + k.Y() * k.Y() + k.Z() * k.Z();
		}
		bool operator > (const Koordinate& k) const{
			return X() * X() + Y() * Y() + Z() * Z() > k.X() * k.X() + k.Y() * k.Y() + k.Z() * k.Z();
		}
		Koordinate operator + (const Koordinate& k) const{
			return Koordinate(X() + k.X(), Y() + k.Y(), Z() + k.Z());
		}
		//redefinisemo operator deljenja celim brojem jer nam je potreban za racunanje proseka		
		Koordinate operator / (int n) const{
			return Koordinate(X()/n, Y()/n, Z()/n);
		}
	private:
		T _x;
		T _y;
		T _z;
};

}

/* sablonski operatori >> i << su predefinisani izvan prostora imena tacka */
template <typename T>
std::istream& operator >> (std::istream& istr, tacka::Koordinate<T>& k){
	T x, y, z;
	istr>> x >> y >> z;
	k.postaviX(x);
	k.postaviY(y);
	k.postaviZ(z);
	return istr;
}

template <typename T>
std::ostream& operator << (std::ostream& ostr,const tacka::Koordinate<T>& k){
	ostr<<"("<< k.X() <<", "<< k.Y() <<", "<< k.Z() <<")";
	return ostr;
}

#endif
