#ifndef OSOBA_H
#define OSOBA_H
#include <iostream>
#include <string>

namespace vrsta{

class Osoba{
	public:
		Osoba(void);
		Osoba(const std::string&, const std::string&, int);
		const std::string& Ime() const;
		const std::string& Prezime() const;
		int GodinaRodjenja() const;
		void postaviIme(const std::string& ime);
		void postaviPrezime(const std::string& prezime);
		void postaviGodinaRodjenja(int godina);
		bool operator <(const Osoba &o) const;
	private:
		std::string _ime;
		std::string _prezime;
		int _godinaRodjenja;
};

std::ostream& operator<<(std::ostream& out, const Osoba &osoba);
std::istream& operator>>(std::istream& out, Osoba &osoba);
}
#endif

