# Sortiranje
#
# sorted(kolekcija [, poredi [, kljuc [, obrni]]]) - vraca sortiranu kolekciju
#
# kolekcija - kolekcija koju zelimo da sortiramo
# poredi - funkcija poredjenja
# kljuc - funkcija koja vraca kljuc po kome se poredi
# obrni - True/False (opadajuce/rastuce)
#
# za poziv sorted(kolekcija) koristi se funkcija cmp za poredjenje
# cmp(x, y) -> integer
# vraca negativnu vrednost za x<y, 0 za x==y, pozitivnu vrednost za x>y
# ako su x i y niske, cmp ih leksikografski poredi
#

import json
import math

l = ["A", "C", "D", "5", "1", "3"]
print l
print "sortirana lista: ", sorted(l)

# u sledecem primeru je neophodno da definisemo svoje funkcije za poredjenje i vracanje kljuca jer je kolekcija lista recnika i za to cmp nema definisano ponasanje 
tacke = [{"teme":"A" , "koordinate": [10.0, 1.1]}, {"teme":"B" , "koordinate": [1.0, 15.0]}, {"teme":"C" , "koordinate": [-1.0, 5.0]}]


# funkcija koja tacke x i y poredi po njihovoj udaljenosti od koordinatnog pocetka
def poredi(x,y):
    if (x[0]*x[0] + x[1]*x[1]) > (y[0]*y[0] + y[1]*y[1]):
        return 1
    else:
        return -1
# funkcija kljuc kao argument ima element kolekcije koja se poredi, u ovom slucaju je to jedan recnik
# povratna vrednost funkcije kljuc je u stvari tip argumenata funkcije poredi
def kljuc(x):
    return x["koordinate"]

sortirane_tacke = sorted(tacke, poredi, kljuc) # ili sorted(tacke, poredi, kljuc, True) ako zelimo opadajuce da se sortira
print "Tacke pre sortiranja:"
for item in tacke:
	print item["teme"],
print "\nTacke nakon sortiranja: "
for item in sortirane_tacke:
	print item["teme"],
print 
