import json
from datetime import datetime

f = open("studenti.json", "r")
lista = json.load(f)
f.close()

# funkcija za poredjenje dva elementa liste studenata
# s obzirom da funkcija kljuc nije promenjena
# ona ce samo proslediti element kolekcije funkciji poredi
# tako da su x i y recnici iz liste studenata
def poredi(x,y):
	if x["prosek"]>y["prosek"]:
		return -1
	elif x["prosek"]<y["prosek"]:
		return 1
	else:
		# na osnovu niski u kojima je zapisan datum upisa
		# pravimo objekte tipa datetime
		d1 = datetime.strptime(x["datum_upisa"],"%d.%m.%Y.")
		d2 = datetime.strptime(y["datum_upisa"],"%d.%m.%Y.")
		# datumi se mogu porediti operatorima <, >, ==
		if d1<d2:
			return 1
		elif d1>d2:
			return -1
		else:
			return 0

# prosledjujemo listu studenata i novu funkciju za poredjenje
# funkcija kljuc se ne menja
sortirana = sorted(lista, poredi)

for x in sortirana:
	print x["ime_prezime"]
