package testList;

import java.net.URL;
import java.util.Comparator;
import java.util.ResourceBundle;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.Button;
import javafx.scene.control.ListView;

public class TestLController implements Initializable{
	
	@FXML
	private ListView<String> listView;
	
	@FXML
	private Button bsort;
	
	private ObservableList<String> listViewData = FXCollections.observableArrayList();
	
	/* konstruktor u kom se postavlja sadrzaj liste, izvrsava se pre metoda za inicijalizaciju */
	public TestLController(){
		listViewData.add(new String("Marko"));
		listViewData.add(new String("Ana"));
		listViewData.add(new String("Jovana"));
		listViewData.add(new String("Bojana"));
	}
	
	@Override
	public void initialize(URL arg0, ResourceBundle arg1) {
		/* postavljanje sadrzaja List View komponente */
		listView.setItems(listViewData);
		
		/* sortiranje sadrzaja pritiskom na dugme */
		bsort.setOnAction(new EventHandler<ActionEvent>() {

			@Override
			public void handle(ActionEvent arg0) {
				listView.getItems().sort(new Comparator<String>() {

					@Override
					public int compare(String name1, String name2) {
						
						return name1.compareTo(name2);
					}
				});
			}
		});
	}

}
