package testSceneBuilder;

import java.io.IOException;
import javafx.application.Application;
import javafx.fxml.FXMLLoader;
import javafx.scene.Scene;
import javafx.scene.layout.BorderPane;
import javafx.stage.Stage;

public class TestSceneBuilder extends Application {

	@Override
	public void start(Stage primaryStage) throws IOException {
		
		/* FXMLLoader klasa je odgovorna za ucitavanje FXML
         * izvornog dokumenta i vracanje dobijenog grafa scene 
         */
		FXMLLoader loader = new FXMLLoader(TestSceneBuilder.class.getResource("TestSB.fxml"));
		
		BorderPane page = (BorderPane) loader.load();
		
		Scene scene = new Scene(page);
		primaryStage.setScene(scene);
		primaryStage.show();
		
	}

	public static void main(String[] args) {
		launch(args);
	}
}
