package cas_1;

import java.util.Scanner;

class Indeks {
	private int i;
	private int n;

	public Indeks(int i, int n) {
		this.i = i;
		this.n = n;
	}
	public int getI() {
		return i;
	}
	public int getN() {
		return n;
	}
	public void setI(int i) {
		this.i = i;
	}
	public void setN(int n) {
		this.n = n;
	}
}

class MojaNit extends Thread {
	/*
	 * sve niti dele iste podatke, dva niza celih brojeva a i b, ali svaka nit
	 * pristupa i-tim elementima, rezultat sabiranja se smesta u prvi niz [a1 a2
	 * a3] + [b1 b2 b3] = [a1+b1 a2+b2 a3+b3]
	 */
	static int a[];
	static int b[];
	static Indeks indeks;
	private int i;
	private boolean radi = true;

	public void run() {
		while (radi) {
			/*
			 * nit pristupa deljenom podatku indeks, ukoliko se doslo do kraja
			 * oba niza, nit prekida izvrsavanje jer se radi postavlja na false,
			 * inace cuva tekuci indeks i uvecava ga za jedan da sledeca nit ne
			 * bi radila sa istim elementima
			 */
			synchronized (indeks) {
				if (indeks.getI() == indeks.getN())
					radi = false;
				else {
					i = indeks.getI();
					indeks.setI(indeks.getI()+1);
				}

			}
			if (radi == false)
				break;
			else {
				/*
				 * indeks i je jedinstven za svaku nit pa sigurno nece vise niti
				 * pristupati istim elementima
				 */
				a[i] = a[i] + b[i];
			}
		}
	}
}

public class Zbir {
	public static void main(String[] args) {
		Scanner sc = new Scanner(System.in);
		System.out.println("Unesite dimenziju za niz");
		int n = sc.nextInt();
		MojaNit.indeks = new Indeks(0, n);
		MojaNit.a = new int[n];
		MojaNit.b = new int[n];
		System.out.println("Unesite elemente prvog niza");
		for (int i = 0; i < n; i++)
			MojaNit.a[i] = sc.nextInt();
		System.out.println("Unesite elemente drugog niza");
		for (int i = 0; i < n; i++)
			MojaNit.b[i] = sc.nextInt();
		sc.close();
		int p = Runtime.getRuntime().availableProcessors();
		/* kreiramo onoliko niti koliko nam je procesora na raspolaganju */
		MojaNit niti[] = new MojaNit[p];
		for (int i = 0; i < p ; i++) {
			niti[i] = new MojaNit();
		}
		for (int i = 0; i < p ; i++) {
			niti[i].start();
		}
		for (int i = 0; i < p ; i++) {
			try {
				niti[i].join();
			} catch (InterruptedException e) {
				e.printStackTrace();
			}
		}
		System.out.print("[");
		for (int i = 0; i < n; i++) {
			if (i != n - 1)
				System.out.print(MojaNit.a[i] + " ");
			else
				System.out.print(MojaNit.a[i]);
		}
		System.out.println("]");
	}
}