package drugi;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.util.ArrayList;
import java.util.Random;

import javax.swing.JPanel;

public class Panel extends JPanel{
	private ArrayList<Drawable> drawables = new ArrayList<>();
	private Prodavnica[] prodavnice = new Prodavnica[4];
	private int[][] Veza = new int[4][4];
	private Prvaci[] djaci = new Prvaci[5];
	private Random rand = new Random();
	
	public Panel(int x, int y){
		setPreferredSize(new Dimension(x,y));
		
		prodavnice[0] = new Prodavnica(50, 50, 15, 30, 'O');
		prodavnice[1] = new Prodavnica(500, 50, 25, 40, 'G');
		prodavnice[2] = new Prodavnica(500, 300, 30, 60, 'S');
		prodavnice[3] = new Prodavnica(50, 300, 15, 30, 'B');
		
		for(int i=0;i<4;i++){
			prodavnice[i].start();
			drawables.add(prodavnice[i]);
		}
		
		Veza[0][1] = 1;
		Veza[1][2] = 1;
		Veza[2][3] = 1;
		Veza[3][0] = 1;
		
		for(int i=0;i<5;i++){
			int ip = rand.nextInt(4);
			int ol = rand.nextInt(21) + 10;
			int gum = rand.nextInt(21) + 10;
			int svs = rand.nextInt(21) + 10;
			int bl = rand.nextInt(21) + 10;
			djaci[i] = new Prvaci(prodavnice[ip].getX(), prodavnice[ip].getY(), ol, gum, svs, bl, this);
			drawables.add(djaci[i]);
			djaci[i].start();
		}
		
	}
	
	public Prodavnica[] getProdavnice() {
		return prodavnice;
	}
	
	public int nalaziSeUprodavnici(Prvaci djak){
		for(int i=0;i<4;i++)
			if(prodavnice[i].contains(djak.getX(), djak.getY()))
				return i;
		return -1;
	}

	public void paint(Graphics g){
		super.paint(g);
		for(Drawable d:drawables)
			d.draw(g);
		g.setColor(Color.BLUE);
		for(int i=0;i<4;i++)
			for(int j=0;j<4;j++)
				if(Veza[i][j]==1)
					g.drawLine(prodavnice[i].getX(), prodavnice[i].getY(), prodavnice[j].getX(), prodavnice[j].getY());
	}

}
