package drugi;

import java.awt.Color;
import java.awt.Graphics;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

public class Prodavnica extends Thread implements Drawable{
	private int x, y, stanje, kapacitet;
	private char oznaka;
	private ReentrantLock lock = new ReentrantLock();
	private Condition sacekaj = lock.newCondition();
	
	public Prodavnica(int x, int y, int stanje, int kapacitet, char oznaka){
		this.x = x;
		this.y = y;
		this.stanje = stanje;
		this.kapacitet = kapacitet;
		this.oznaka = oznaka;
	}
	
	public void draw(Graphics g){
		g.setColor(Color.RED);
		g.fillRect(x, y, 80, 20);
		g.setColor(Color.BLACK);
		if(oznaka=='O')
			g.drawString("Olovke: " + stanje, x + 8, y + 13);
		else if(oznaka == 'G')
			g.drawString("Gumice: " + stanje, x + 8, y + 13);
		else if(oznaka == 'S')
			g.drawString("Sveske: " + stanje, x + 8, y + 13);
		else
			g.drawString("Blokovi: " + stanje, x + 8, y + 13);
	}
	
	//Niti koje ne mogu da ispune svoj zadatak tj. ako na stanju nema onoliko stvari koliko djaku treba, ta nit
	//se zaustavlja dok stanje ne bude maksimalno
	public void kupovina(Prvaci djak){
		lock.lock();
		if(djak.getOlovke()>stanje && oznaka=='O'){
			try {
				sacekaj.await();
			} catch (InterruptedException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		}
		lock.unlock();
		lock.lock();
		if(djak.getSveske()>stanje && oznaka=='S'){
			try {
				sacekaj.await();
			} catch (InterruptedException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		}
		lock.unlock();
		lock.lock();
		if(djak.getGumice()>stanje && oznaka=='G'){
			try {
				sacekaj.await();
			} catch (InterruptedException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		}
		lock.unlock();
		lock.lock();
		if(djak.getBlokovi()>stanje && oznaka=='B'){
			try {
				sacekaj.await();
			} catch (InterruptedException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		}
		lock.unlock();
		
		if(oznaka=='O' && djak.getOlovke()!=0){
			stanje-=djak.getOlovke();
			djak.setOlovke(0);
		}
		else if(oznaka=='G' && djak.getGumice()!=0){
			stanje-=djak.getGumice();
			djak.setGumice(0);
		}
		else if(oznaka == 'S' && djak.getSveske()!=0){
			stanje-=djak.getSveske();
			djak.setSveske(0);
		}
		else if(djak.getBlokovi()!=0){
			stanje-=djak.getBlokovi();
			djak.setBlokovi(0);
		}
		
		//Ako smo napunili korpu, postavljam full na true
		if(djak.getOlovke()==0 && djak.getGumice()==0 && djak.getBlokovi()==0 && djak.getSveske()==0)
			djak.setFull(true);
	}
	
	//Run metod za dopunjavanje prodavnice
	public void run(){
		while(true){
			try {
				
				lock.lock();
				if(stanje<kapacitet){
					stanje = kapacitet;
					sacekaj.signalAll();
				}
				lock.unlock();
				
				Thread.sleep(5000);
			} catch (InterruptedException e) {
				e.printStackTrace();
			}
		}
	}
	
	//f-ja koja proverava da li se djak nalazi u stanici
	public boolean contains(int x1, int y1){
		return (x==x1 && y==y1);
	}
	
	//Ako korpa nije napunjena pokusavamo kupovinu
	public void razmena(Prvaci djak){
		if(djak.isFull()==false)
			kupovina(djak);
	}

	public int getX() {
		return x;
	}

	public int getY() {
		return y;
	}

}
