# Aproksimacija broja PI metodom Monte Karlo

import random, math

def dist(A, B):
    """Funkcija izracunava euklidsko rastojanje izmedju tacaka A i B"""
    return math.sqrt((A[0]-B[0])**2 + (A[1]-B[1])**2)

print "Izracunavanje broja PI metodom Monte Karlo \n"
N = int(raw_input("Unesite broj iteracija: "))
A = 0   # Broj tacaka u krugu
B = 0   # Broj tacaka u kvadratu

i = N
while i >= 0:
    tacka = (random.random(), random.random())
    # Ukoliko se tacka nalazi u krugu, povecavamo broj tacaka u krugu
    if dist(tacka, (0.5, 0.5)) <= 0.5:
        A = A + 1
    B = B + 1
    i = i - 1

# Alternativno resenje:
# Generisemo N tacaka unutar kvadrata
# list comprehensions:
# http://www.pythonforbeginners.com/basics/list-comprehensions-in-python
xs = [(random.random(), random.random()) for x in range(N)]
# Izdvajamo tacke koje su unutar kvadrata
# lambde:
# https://pythonconquerstheuniverse.wordpress.com/2011/08/29/lambda_tutorial/
inside = filter(lambda (x, y): dist((0.5, 0.5), (x, y)) <= 0.5, xs)
A = len(inside)
B = N

print "Broj PI aproksimiran metodom Monte Karlo: "
print 4.0*A/B
