import constraint

problem = constraint.Problem()
# Definisemo promenljive za svaki novcic
# ako bi se zahtevalo da u kombinaciji bude od svake vrednosti bar po jedan novcic samo treba promeniti da domen za svaku promenljivu krece od 1
problem.addVariable("1 din",range(0,51))
problem.addVariable("2 din",range(0,26))
problem.addVariable("5 din",range(0,11))
problem.addVariable("10 din",range(0,6))
problem.addVariable("20 din",range(0,3))


# I nacin 
problem.addConstraint(constraint.ExactSumConstraint(50,[1,2,5,10,20]), ["1 din", "2 din", "5 din","10 din", "20 din"])

# II nacin je da definisemo svoju funkciju koja predstavlja ogranicenje, samo ce sada solver nesto sporije da radi posto ugradjene funkcije imaju optimizovanu pretragu i brze dolaze do resenja
#
#def o(a, b, c, d, e):
#	if a + 2*b + 5*c + 10*d + 20*e == 50:
#		return True
#
#problem.addConstraint(o, ["1 din", "2 din", "5 din","10 din", "20 din"])
#
resenja = problem.getSolutions()

for r in resenja:
	print r
	# Provera da je suma bas 50
	print r["1 din"] + r["2 din"]*2 + r["5 din"]*5 + r["10 din"]*10 + r["20 din"]*20
