package sample;



import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.Button;
import javafx.scene.control.Label;

import java.net.URL;
import java.util.ResourceBundle;

public class Controller implements Initializable {

    /*
     * Controller klasa:
     *
     * - implementira interfejs Initializable
     *
     * Klasa koja implementira "kod u pozadini" (dogadjaje u pozadini)
     * hijerarhije objekata koja je definisana FXML dokumentom.
     *
     * Kontroleri se koriste za implementaciju EventHandler-a za rukovanje
     * dogadjajima vezanih za elemente grafickog korisnickog interfejsa
     * (koji je opisan FXML dokumentom).
     *
     * Potrebno je u SceneBuilder-u postaviti controller klasu
     * korenom elementu grafa scene:
     * Controller -> Controller class -> sample.Controller
     *
     * Na taj nacin se omogucava JavaFX Scene Builder-u da pristupi
     * nazivima EventHandler-a i deklaracijama instancnih promenljivih.
     *
     * Automatski ce biti dodat atribut
     * 		fx:controller
     * u FXML dokument kojim se povezuje FXML dokument i klasa za kontrolu
     *
     */

    /* Ukoliko se u kontroler klasi polja clanovi ili
     * metodi za upravljanje dogadjajima oznace kao
     * private ili protected
     * neophodno je oznaciti ih obelezjem
     * javafx.fxml.FXML (@FXML)
     * kako bi FXML dokument mogao da im pristupi
     * ili da ih menja.
     */

    @FXML
    private Button dugme;

    @FXML
    private Label labela;

   /* Klikom na dugme, dugme postaje nevidljivo, ispisuje se poruka na standardni izlaza
   i na labelu se dodaje tekst koji ce biti obojen zeleno
   * */

    @FXML
    private void handleButtonAction(ActionEvent event) {
        System.out.println("ZDRAVO!!!");
        dugme.setVisible(false);
        labela.setText("Kliknuli ste na dugme!");
        labela.setStyle("-fx-text-fill: green");
    }

    @Override
    public void initialize(URL location, ResourceBundle resources) {

    }

    /*
     * Najcesce je dovoljno da se rukovanje dogadjajima definise
     * na prethodno opisani nacin. Ako je potrebno da se postigne veca kontrola
     * nad ponasanjem kontrolera i elemenata kojima upravlja, moze
     * se implementirati metod initialize().
     * U tom slucaju staviti pod komentar prethodne metode.
     * Metod initialize() se poziva jednom, prilikom implementacije kontrolera,
     * kada su sadrzaji pridruzenih FXML dokumenata u potpunosti ucitani.
     * Time se omogucuje izvsenje post-procesiranja nad sadrzajem,
     * pristup resursima koriscenim pri ucitavanju dokumenata
     * ili lokacijama koriscenim za resavanje relativnih putanja
     * u dokumentu.
     */

    /*
    @Override
    public void initialize(URL url, ResourceBundle rb) {
    	dugme.setOnAction(new EventHandler<ActionEvent>() {
    		@Override
    		public void handle(ActionEvent event) {
    			System.out.println("ZDRAVO!!!");
                dugme.setVisible(false);
                labela.setText("Kliknuli ste na dugme!");
                labela.setStyle("-fx-text-fill: green");
    		}
    	});

    }
    */
}
