package sample;

import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.*;
import javafx.scene.shape.Circle;
import javafx.scene.text.Text;

import java.net.URL;
import java.util.ResourceBundle;

public class Controller implements Initializable {

    @FXML
    private Slider slider;

   @FXML
   private Circle krug;

   /* Precnik kruga se postavlja na tekucu vrednost slajdera tako sto se preko osluskivaca prati promena
   * na slajderu
   *
   * Inicijalno se postavlja da je slajder na 0, pa u skladu sa tim krug na pocetku nije vidljiv
   *
   * */

    @Override
    public void initialize(URL location, ResourceBundle resources) {
        slider.valueProperty().addListener(new ChangeListener<Number>() {
            @Override
            public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
                krug.setRadius((Double) newValue);

            }
        });
    }
}
