
/*
 * niti se mogu kreirati i kao elementi klasa koje implemetiraju
 * Runnable-interfejs  i metod run() koji je jedini metod ovog interfejsa
 * i sluzi za definisanje nacina rada niti u klasi gde se koristi

 Prednost koriscenja interfejsa je ta sto nasa klasa u ovom slucaju moze da
 nasledi neku drugu klasu koja nije Thread, a opet mozemo kreirati nit koja ce
 izvrsavati kod definisan metodom run() tako sto u konstruktoru prosledimo instancu
 nase klase.

 Takodje, u ovom slucaju, objekti nase klase nisu nit, vec sadrze polje podatak - nit
 Dodatno, mozemo definisati klasu koja ne sadrzi nijedno polje, pa ni nit i instancu nase klase
 proslediti prilikom poziva konstruktora klase Thread iz main-a
 */
class MojaNit implements Runnable {
    Thread t;

    MojaNit(String s1) {
        /*
         * konstuktoru se salje instanca nase klase koja implementira Runnable
         * interfejs, nit t ce izvrsavati kod definisan u metodu run nase klase
         */
        t = new Thread(this);
        t.setName(s1);
    }

    public void run() {
        System.out.println("Nit koja se trenutno izvrsava: "
                + Thread.currentThread().getName() + ".");
    }
}

public class Main {
    public static void main(String args[]) {
        MojaNit m1 = new MojaNit("moja prva nit");
        m1.t.start();
        /* ukoliko ne zelimo da metod run izvrsava zasebna nit, vec main nit */
        m1.run();
    }
}