

class MojaNit extends Thread {


    MojaNit(String s) {
        super(s);
    }

    public void run() {
        for (int i = 0; i < 10; i++) {
            // staticki metod koji vraca nit koja izvrsava tekuci blok
            Thread cur = Thread.currentThread();
            System.out.println("(nit "
                    + cur.getName() + ", prioritet: "
                    + cur.getPriority()
                    + ").");

        }
    }
}

public class Main {
    public static void main(String args[]) {
        MojaNit nit1 = new MojaNit("Prva nit");
        MojaNit nit2 = new MojaNit("Druga nit");

        /*
         * da bismo bili sigurni da ce poslednji ispis main nit odraditi
         * nakon sto njene niti deca zavrse svoj posao koristimo metod join
         * koji obezbedjuje izvrsavanje nekog koda (niti) tek posto neka druga nit zavrsi svoje
         * izvrsavanje (kada dodje do kraja run-metoda), u nasem primeru glavna
         * nit ceka da se prvo nit1 zavrsi, pa nit2
         */
        try {
            nit1.start();
            nit2.start();
            nit1.join();
            nit2.join();
            if (!nit1.isAlive())
                System.out.println("Prva nit je zavrsila svoj posao");
            if (!nit2.isAlive())
                System.out.println("Druga nit je zavrsila svoj posao");

            System.out.println("Nema vise aktivnih niti-dece");
        } catch (InterruptedException e) {
            e.printStackTrace();
        }
    }
}