
import java.util.Scanner;
import java.util.Vector;

// objekti klase Indeks ce sluziti za komunikaciju izmedju niti
// i je indeks prvog neobradjenog elementa vektora
// n je dimenzija vektora
class Indeks {
    private int i;
    private int n;

    public Indeks(int i, int n) {
        this.i = i;
        this.n = n;
    }
    public void setI(int i) {
        this.i = i;
    }
    public int getI() {
        return i;
    }
    public void setN(int n) {
        this.n = n;
    }
    public int getN() {
        return n;
    }
}

class MojaNit extends Thread {
    static Vector<Integer> vektor;
    static int skalar;
    /*
     * deljena promenljiva indeks sadrzi indeks elementa vektora koji je sledeci
     * na redu za mnozenje skalarom i dimenziju vektora
     */
    static Indeks indeks;
    private int i;
    private boolean radi = true;

    public void run() {
        while (radi) {
            /*
             * nit pristupa deljenom podatku indeks, ukoliko se doslo do kraja
             * vektora, nit prekida izvrsavanje jer se radi postavlja na false,
             * inace cuva tekuci indeks i uvecava ga za jedan da sledeca nit ne
             * bi radila sa istim elementom vektora
             */
            synchronized (indeks) {
                if (indeks.getI() == indeks.getN())
                    radi = false;
                else {
                    i = indeks.getI();
                    indeks.setI(indeks.getI()+1);
                }

            }
            if (radi == false)
                break;
            else {
                /*
                 * indeks i je jedinstven za svaku nit pa sigurno nece vise niti
                 * pristupati istom elementu u vektoru
                 */
                vektor.set(i, vektor.get(i) * skalar);
            }
        }
    }
}

public class Main {
    public static void main(String[] args) {
        Scanner sc = new Scanner(System.in);
        System.out.println("Unesite dimenziju vektora");
        int n = sc.nextInt();
        MojaNit.indeks = new Indeks(0, n);
        MojaNit.vektor = new Vector<Integer>();
        System.out.println("Unesite elemente vektora");
        for (int i = 0; i < n; i++)
            MojaNit.vektor.add(sc.nextInt());
        System.out.println("Unesite skalar");
        MojaNit.skalar = sc.nextInt();
        sc.close();
        int p = Runtime.getRuntime().availableProcessors();
        /* kreiramo onoliko niti koliko nam je procesora na raspolaganju */
        MojaNit niti[] = new MojaNit[p];
        for (int i = 0; i < p ; i++) {
            niti[i] = new MojaNit();
        }
        for (int i = 0; i < p ; i++) {
            niti[i].start();
        }
        for (int i = 0; i < p ; i++) {
            try {
                niti[i].join();
            } catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        System.out.print("(");
        for (int i = 0; i < n; i++) {
            if (i != n - 1)
                System.out.print(MojaNit.vektor.get(i) + " ");
            else
                System.out.print(MojaNit.vektor.get(i));
        }
        System.out.println(")");
    }
}