
import java.util.Scanner;
import java.util.Vector;

class Podaci {
    private int i;
    private int n;
    private int rezultat;

    public Podaci(int i, int n, int rezultat) {
        this.i = i;
        this.n = n;
        this.rezultat = rezultat;
    }
    public int getI() {
        return i;
    }
    public int getN() {
        return n;
    }
    public int getRezultat() {
        return rezultat;
    }
    public void setI(int i) {
        this.i = i;
    }
    public void setN(int n) {
        this.n = n;
    }
    public void setRezultat(int rezultat) {
        this.rezultat = rezultat;
    }
}

class MojaNit extends Thread {
    /*
     * sve niti dele iste podatke, dva vektora a i b ciji se skalarni proizvod
     * racuna, ali nit pristupa i-tim elementima vektora,
     * (a1 a2 a3)*(b1 b2 b3) = a1*b1 + a2*b2 + a3*b3
     */
    static Vector<Integer> a;
    static Vector<Integer> b;
    static Podaci podatak;
    private int i;
    private boolean radi = true;

    public void run() {
        while (radi) {
            /*
             * nit pristupa deljenom podatku podatak, ukoliko se doslo do kraja
             * vektora, nit prekida izvrsavanje jer se radi postavlja na false,
             * inace cuva tekuci indeks i uvecava ga za jedan da sledeca nit ne
             * bi radila sa istim elementima vektora a i b
             */
            synchronized (podatak) {
                if (podatak.getI() == podatak.getN())
                    radi = false;
                else {
                    i = podatak.getI();
                    podatak.setI(podatak.getI()+1);
                }

            }
            if (radi == false)
                break;
            else {
                /*
                 * posto je rezultat takodje deljeni podatak moramo
                 * sinhronizovati blok u kom ga nit modifikuje
                 */
                synchronized (podatak) {
                    podatak.setRezultat(podatak.getRezultat() + a.get(i) * b.get(i));
                }
            }
        }
    }
}

public class Main {
    public static void main(String[] args) {
        Scanner sc = new Scanner(System.in);
        System.out.println("Unesite dimenziju vektora");
        int n = sc.nextInt();
        MojaNit.podatak = new Podaci(0, n, 0);
        MojaNit.a = new Vector<Integer>();
        System.out.println("Unesite elemente prvog vektora");
        for (int i = 0; i < n; i++)
            MojaNit.a.add(sc.nextInt());
        MojaNit.b = new Vector<Integer>();
        System.out.println("Unesite elemente drugog vektora");
        for (int i = 0; i < n; i++)
            MojaNit.b.add(sc.nextInt());
        sc.close();
        int p = Runtime.getRuntime().availableProcessors();
        /* kreiramo onoliko niti koliko nam je procesora na raspolaganju */
        MojaNit niti[] = new MojaNit[p];
        for (int i = 0; i < p ; i++) {
            niti[i] = new MojaNit();
        }
        for (int i = 0; i < p ; i++) {
            niti[i].start();
        }
        for (int i = 0; i < p ; i++) {
            try {
                niti[i].join();
            } catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        System.out.println("Skalarni proizvod unetih vektora je "
                + MojaNit.podatak.getRezultat());
    }
}