import java.util.Scanner;

class Indeks {
    private int i;
    private int n;

    public Indeks(int i, int n) {
        this.i = i;
        this.n = n;
    }
    public void setI(int i) {
        this.i = i;
    }
    public int getI() {
        return i;
    }
    public void setN(int n) {
        this.n = n;
    }
    public int getN() {
        return n;
    }
}

class MojaNit extends Thread {
    static int a[];
    /*
     * deljena promenljiva indeks sadrzi indeks elementa niza koji je sledeci na
     * proveri i dimenziju niza
     */
    static Indeks indeks;
    private int i;
    private boolean radi = true;

    public void run() {
        while (radi) {
            synchronized (indeks) {
                /*
                 * nit pristupa deljenom podatku indeks, ukoliko se doslo do
                 * kraja niza, nit prekida izvrsavanje jer se radi postavlja na
                 * false, inace cuva tekuci indeks i uvecava ga za jedan da
                 * sledeca nit ne bi radila sa istim elementom niza
                 */
                if (indeks.getI() == indeks.getN())
                    radi = false;
                else {
                    i = indeks.getI();
                    indeks.setI(indeks.getI()+1);
                }

            }
            if (radi == false)
                break;
            else {
                if (prost(a[i]))
                    System.out.println("Na poziciji " + i + " je prost broj "
                            + a[i] + ".");
            }
        }
    }

    private boolean prost(int j) {
        for (int k = 2; k <= Math.sqrt(j); k++)
            if (j % k == 0)
                return false;
        return true;
    }
}

public class Main {
    public static void main(String[] args) {
        Scanner sc = new Scanner(System.in);
        System.out.println("Unesite dimenziju niza");
        int n = sc.nextInt();
        MojaNit.indeks = new Indeks(0, n);
        MojaNit.a = new int[n];
        System.out.println("Unesite elemente niza");
        for (int i = 0; i < n; i++)
            MojaNit.a[i] = sc.nextInt();
        sc.close();
        int p = Runtime.getRuntime().availableProcessors();
        /* kreiramo onoliko niti koliko nam je procesora na raspolaganju */
        MojaNit niti[] = new MojaNit[p];
        for (int i = 0; i < p ; i++) {
            niti[i] = new MojaNit();
        }
        for (int i = 0; i < p; i++) {
            niti[i].start();
        }
    }
}
