

import java.util.Scanner;

/*
 * objekat klase Indeksi predstavlja deljeni podatak za niti,
 * odnosno sadrzi indekse vrste prve matrice i kolone druge matrice
 * koje su na redu za mnozenje
 */
class Indeksi {
    private int i;
    private int j;

    public Indeksi(int i, int j) {
        this.i = i;
        this.j = j;
    }
    public void setI(int i) {
        this.i = i;
    }
    public void setJ(int j) {
        this.j = j;
    }
    public int getI() {
        return i;
    }
    public int getJ() {
        return j;
    }
}

class MojaNit extends Thread {
    static int a[][];
    static int b[][];
    static int rezultat[][];
    static int n;
    private int i;
    private int j;
    static Indeksi indeksi = new Indeksi(0, 0);
    private boolean radi = true;

    public void run() {
        while (radi) {
            synchronized (indeksi) {
                /*
                 * nit pristupa deljenom podatku ako je vrsta dosla do n znaci
                 * da je zavrseno mnozenje matrica
                 */
                if (indeksi.getI() == n)
                    radi = false;
                else {
                    /*
                     * nit cuva sa kojom vrstom i kolonom treba da radi i
                     * uvecava indekse da sledeca nit koja pristupi podacima ne
                     * bi radila sa istim delom matrice
                     */
                    i = indeksi.getI();
                    j = indeksi.getJ();
                    /*
                     * ako jos uvek postoji kolona koja se nije pomnozila sa
                     * i-tom vrstom, uvecavamo indeks kolone
                     */
                    if (indeksi.getJ() < n - 1)
                        indeksi.setJ(indeksi.getJ()+1);
                    else {
                        /*
                         * prelazimo na sledecu vrstu i pocinjemo od nulte
                         * kolone za mnozenje
                         */
                        indeksi.setI(indeksi.getI()+1);
                        indeksi.setJ(0);
                    }
                }
            }
            if (radi == false)
                break;
            else {
                rezultat[i][j] = 0;
                for (int k = 0; k < n; k++)
                    rezultat[i][j] += a[i][k] * b[k][j];

            }
        }
    }
}

public class Main {
    public static void main(String[] args) {
        Scanner sc = new Scanner(System.in);
        System.out.println("Unesite dimenziju kvadratne matrice");
        MojaNit.n = sc.nextInt();
        MojaNit.a = new int[MojaNit.n][MojaNit.n];
        MojaNit.b = new int[MojaNit.n][MojaNit.n];
        System.out.println("Unesite elemente prve matrice");
        for (int i = 0; i < MojaNit.n; i++)
            for (int j = 0; j < MojaNit.n; j++)
                MojaNit.a[i][j] = sc.nextInt();
        System.out.println("Unesite elemente druge matrice");
        for (int i = 0; i < MojaNit.n; i++)
            for (int j = 0; j < MojaNit.n; j++)
                MojaNit.b[i][j] = sc.nextInt();
        sc.close();
        MojaNit.rezultat = new int[MojaNit.n][MojaNit.n];
        int p = Runtime.getRuntime().availableProcessors();
        /* kreiramo onoliko niti koliko nam je procesora na raspolaganju */
        MojaNit niti[] = new MojaNit[p];
        for (int i = 0; i < p; i++) {
            niti[i] = new MojaNit();
        }
        for (int i = 0; i < p; i++) {
            niti[i].start();
        }
        for (int i = 0; i < p; i++) {
            try {
                niti[i].join();
            } catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        for (int[] vrsta : MojaNit.rezultat) {
            for (int el : vrsta)
                System.out.print(el + " ");
            System.out.println();
        }
    }
}