import java.util.Random;

class Banka {
    private Klijent[] klijenti;
    private Random rg;

    public Banka() {
        rg = new Random();
        klijenti = new Klijent[100];
        for (int i = 0; i < klijenti.length; i++)
            klijenti[i] = new Klijent(i, 100, this);
        for (int i = 0; i < klijenti.length; i++)
            klijenti[i].start();
    }

    public Random getRg() {
        return rg;
    }

    /*
     * transfer metod je kljucan, jer se tu desava operacija koja potencijalno
     * moze da narusi integritet podataka. Sta sve moze da se desi ako nit bude
     * prekinuta od strane druge niti u trenutku kada je izvrsila
     * dekrementaciju, a nije jos inkrementaciju? Kada se pokrene program moze
     * se videti da ukupan zbir svih depozita nije uvek 10000, dakle integritet
     * podataka je narusen
     */
    void transfer(int id1, int id2, int kolicina) {
        /*
         * id1 je id klijenta sa cijeg racuna se skida novac u iznosu kolicina
         * id2 je id klijenta na ciji racun se dodaje novac u iznosu kolicina
         * dozvoljavamo da se skida sa racuna iako nema dovoljno sredstava, sa
         * ovim cemo se pozabaviti kasnije
         */
        klijenti[id1].setStanje(klijenti[id1].getStanje()-kolicina);
        klijenti[id2].setStanje(klijenti[id2].getStanje()+kolicina);
        System.out.printf("k%d->k%d, kolicina: %d, stanje k%d: %d, total: %d\n", id1, id2, kolicina, id1, klijenti[id1].getStanje(), total());
    }

    /*
     * funkcija total() racuna ukupan zbir svih depozita u banci
     */
    int total() {
        int total = 0;
        for (int i = 0; i < klijenti.length; i++)
            total += klijenti[i].getStanje();
        return total;
    }

}

/*
 * svaki klijent predstavlja jednu nit, metod run() poziva funkciju transfer()
 * koja vrsi prebacivanje novca sa jednog na drugi racun u banci
 */
class Klijent extends Thread {
    private int idn;
    private int stanje;
    private Banka banka;

    public Klijent(int id, int stanje, Banka banka) {
        this.idn = id;
        this.stanje = stanje;
        this.banka = banka;
    }

    public long getIdn() {
        return idn;
    }

    public int getStanje() {
        return stanje;
    }
    public void setStanje(int stanje) {
        this.stanje = stanje;
    }
    @Override
    public void run() {
        super.run();
        while (true) {
            int id2 = banka.getRg().nextInt(100);
            int kolicina = banka.getRg().nextInt(100);
            banka.transfer(idn, id2, kolicina);
            try {
                sleep(10);
            } catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }
}
public class Main{
    public static void main(String[] args){
        Banka banka  = new Banka();

    }
}