import java.util.Random;
import java.util.concurrent.locks.ReentrantLock;

class Banka2 {
    private Klijent[] klijenti;
    private Random rg;

    /*
     * ReentrantLock je "katanac", poznat i pod imenom "semafora". Predstavlja
     * softversku apstrakciju za zakljucavanje kriticnih sekcija (regiona koda
     * koji smeju da budu izvrsavani ekskluzivno od jedne niti u datom momentu)
     */
    private ReentrantLock katanac;

    public Banka2() {
        rg = new Random();
        katanac = new ReentrantLock();
        klijenti = new Klijent[100];
        for (int i = 0; i < klijenti.length; i++)
            klijenti[i] = new Klijent(i, 100, this);
        for (int i = 0; i < klijenti.length; i++)
            klijenti[i].start();
    }

    public Random getRg() {
        return rg;
    }

    /*
     * nakon primene zakljucavanja, vise nema problema sa integritetom podataka,
     * ukupna suma depozita u banci je uvek 10000
     */
    void transfer(int id1, int id2, int kolicina) {
        /*
         * kada nit izvrsava kriticnu sekciju ona je prvo zakljuca kako druge
         * niti ne bi mogle da udju. Ispod zita se zapravo desava da postoji
         * binarna promenljiva koja postane 0 ukoliko je nit usla u kriticnu
         * sekciju, a kada izadje vraca se na 1, kako bi druga nit mogla da
         * udje. Ovo moze da bude postavljeno i obrnuto (0 kada je slobodno, 1
         * za zauzeto, stvar implementacije).
         */
        katanac.lock();
        klijenti[id1].setStanje(klijenti[id1].getStanje() - kolicina);
        klijenti[id2].setStanje(klijenti[id2].getStanje() + kolicina);
        System.out.printf("k%d->k%d, kolicina: %d, stanje k%d: %d, total: %d\n", id1, id2, kolicina, id1, klijenti[id1].getStanje(), total());
        /* otkljucavamo da bi i neka druga nit mogla da udje */
        katanac.unlock();
    }

    /*
     * funkcija total() racuna ukupan zbir svih depozita u banci
     */
    int total() {
        int total = 0;
        for (int i = 0; i < klijenti.length; i++)
            total += klijenti[i].getStanje();
        return total;
    }
}

/*
 * svaki klijent predstavlja jednu nit, metod run() poziva funkciju transfer()
 * koja vrsi prebacivanje novca sa jednog na drugi racun u banci
 */
class Klijent extends Thread {
    private int idn;
    private int stanje;
    private Banka2 banka;

    public Klijent(int id, int stanje, Banka2 banka) {
        this.idn = id;
        this.stanje = stanje;
        this.banka = banka;
    }

    public long getIdn() {
        return idn;
    }

    public int getStanje() {
        return stanje;
    }

    public void setStanje(int stanje) {
        this.stanje = stanje;
    }

    @Override
    public void run() {
        super.run();
        while (true) {
            int id2 = banka.getRg().nextInt(100);
            int kolicina = banka.getRg().nextInt(100);
            banka.transfer(idn, id2, kolicina);
            try {
                sleep(10);
            } catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }
}

public class Main2{
    public static void main(String[] args){
        Banka2 banka  = new Banka2();

    }
}
