import java.util.Random;
import java.util.concurrent.locks.ReentrantLock;

public class Covek extends Thread {
	private int kupljeno = 0;
	private Prodavnica[] prodavnice;
	private ReentrantLock lock;

	public Covek(Prodavnica[] prodavnice, ReentrantLock lock) {
		this.prodavnice = prodavnice;
		this.lock = lock;
		start();
	}

	public int getKupljeno() {
		return kupljeno;
	}

	@Override
	public void run() {
		while (true) {
			try {
				Random rand = new Random();
				int izabranaProdavnica = rand.nextInt(4);
				int brojCokoladica = rand.nextInt(7) + 1;
				/*
				 * zakljucavamo kriticnu sekciju 
				 */
				if (prodavnice[izabranaProdavnica].getBrojCokoladica() >= brojCokoladica) {
					lock.lock();
					kupljeno += brojCokoladica;
					prodavnice[izabranaProdavnica]
							.setBrojCokoladica(prodavnice[izabranaProdavnica]
									.getBrojCokoladica() - brojCokoladica);
					lock.unlock();
				}
				Thread.sleep(500);
			} catch (InterruptedException e) {
				e.printStackTrace();
			}
		}
	}
}
