import java.util.concurrent.locks.ReentrantLock;

class CokoladniSvet extends Thread
{
    private Skladiste skladiste;
    private Prodavnica prodavnice[];
    private Covek ljudi[];
    private ReentrantLock lock;

    public CokoladniSvet() {
        lock = new ReentrantLock();
        start();
        skladiste = new Skladiste();
        prodavnice = new Prodavnica[4];
        for (int i = 0; i < 4; i++) {
            prodavnice[i] = new Prodavnica(skladiste, lock);

            /*
             * prodavnice uzimaju dodatne cokoladice iz skladista na svakih 5 sekundi
             */
            prodavnice[i].start();
        }


        /*
         * ljudi na svakih 0.5 sekundi kupuju od 1 do 7 cokoladica
         */
        ljudi = new Covek[100];
        for (int i = 0; i < ljudi.length; i++) {
            ljudi[i] = new Covek(prodavnice, lock);
        }

    }

    public int getUkupnoCokolade() {
        int sum = skladiste.getStanje();
        for (int i = 0; i < 4; i++) {
            sum += prodavnice[i].getBrojCokoladica();
        }
        for (int i = 0; i < 100; i++) {
            sum += ljudi[i].getKupljeno();
        }

        return sum;
    }

    @Override
    public void run() {
        while (true) {
            try {
                Thread.sleep(1000);
                System.out.println("-------------------------");
                System.out.println("Skladiste: " + skladiste.getStanje());

                lock.lock();
                    for (int i = 0; i < 4; i++)
                        System.out.println("Prodavnica " + (i+1) + ": " + prodavnice[i].getBrojCokoladica());
                    System.out.println("Ukupno cokolade u cokoladnom svetu: " + getUkupnoCokolade() + "\n");
                lock.unlock();

            } catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }
}

public class Main{
    public static void main(String[] args){
        CokoladniSvet coko = new CokoladniSvet();

    }

}

